<RESOURCE_PROFILE>
	<HEADER>
		<RESOURCE_IDENTIFIER value="775d4a1c-67f5-473d-a838-ab22d5c5231d_VHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZXMvVHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZVR5cGU="/>
		<RESOURCE_TYPE value="TransformationRuleDSResourceType"/>
		<RESOURCE_KIND value="TransformationRuleDSResources"/>
		<RESOURCE_URI value=""/>
		<DATE_OF_CREATION value="2015-02-27T17:15:30+00:00"/>
	</HEADER>
	<BODY>
		<CONFIGURATION>
			<SOURCE_METADATA_FORMAT name="dbmf" layout="store" interpretation="cleaned"/>
			<SINK_METADATA_FORMAT name="oaf_hbase"/>
			<IMPORTED/>
			<SCRIPT>
				<TITLE>xslt_mapping_claimRels2hbase</TITLE>
				<CODE>
					<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					                xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
					                xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa"
					                xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dnet="eu.dnetlib.data.transform.xml.DbmfToHbaseXsltFunctions"
					                xmlns:exslt="http://exslt.org/common"
					                xmlns:action="http://namespace.openaire.eu/action" version="1.0"
					                extension-element-prefixes="exslt"
					                exclude-result-prefixes="xsl dc dr dri oaa oaf dnet exslt">

						<xsl:output omit-xml-declaration="yes" indent="yes"/>

						<xsl:template match="/*">

							<xsl:variable name="provenance">
								<xsl:value-of select="//FIELD[@name = 'provenance']"/>
							</xsl:variable>
							<xsl:variable name="trust">0.9</xsl:variable>

							<xsl:choose>
								<xsl:when test="count(//RELATION) = 0">
									<ROWS/>
								</xsl:when>
								<xsl:otherwise>
									<ROWS>
										<xsl:for-each select="//RELATION">
											<xsl:choose>
												<xsl:when test="./@type = 'resultProject'">
													<xsl:variable name="resultId" select="./@source"/>
													<xsl:variable name="projectId">
														<xsl:choose>
															<xsl:when test="starts-with(@target, '40|')">
																<xsl:value-of select="./@target"/>
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="dnet:oafSplitId('project', normalize-space(@target))"/>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>

													<ROW key="{$resultId}" columnFamily="resultProject_outcome_isProducedBy">
														<QUALIFIER name="{$projectId}" type="base64">
															<xsl:value-of
																	select="dnet:rel($resultId, $projectId, 'resultProject', 'outcome', 'isProducedBy', $provenance, $trust)"/>
														</QUALIFIER>
													</ROW>
													<ROW key="{$projectId}" columnFamily="resultProject_outcome_produces">
														<QUALIFIER name="{$resultId}" type="base64">
															<xsl:value-of
																	select="dnet:rel($projectId, $resultId, 'resultProject', 'outcome', 'produces', $provenance, $trust)"/>
														</QUALIFIER>
													</ROW>
												</xsl:when>
												<xsl:when test="./@type = 'resultResult_publicationdataset_isRelatedTo'">
													<xsl:variable name="source" select="./@source"/>
													<xsl:variable name="target" select="./@target"/>

													<ROW key="{$source}" columnFamily="resultResult_publicationDataset_isRelatedTo">
														<QUALIFIER name="{$target}" type="base64">
															<xsl:value-of
																	select="dnet:rel($source, $target, 'resultResult', 'publicationDataset', 'isRelatedTo', $provenance, $trust)"/>
														</QUALIFIER>
													</ROW>
													<ROW key="{$target}" columnFamily="resultResult_publicationDataset_isRelatedTo">
														<QUALIFIER name="{$source}" type="base64">
															<xsl:value-of
																	select="dnet:rel($target, $source, 'resultResult', 'publicationDataset', 'isRelatedTo', $provenance, $trust)"/>
														</QUALIFIER>
													</ROW>
												</xsl:when>
											</xsl:choose>
										</xsl:for-each>
									</ROWS>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:template>
					</xsl:stylesheet>
				</CODE>
			</SCRIPT>
		</CONFIGURATION>
		<STATUS/>
		<SECURITY_PARAMETERS>SECURITY_PARAMETERS</SECURITY_PARAMETERS>
	</BODY>
</RESOURCE_PROFILE>
