<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
	xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions">

	<xsl:param name="parentDatasourceId" />
	<xsl:param name="namespacePrefix" />
	
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::WT')" />

	<xsl:variable name="fundingIDtemp">
		<xsl:choose>
			<xsl:when test="string-length(normalize-space(.//FundingStream)) &gt; 0">
				<xsl:value-of select="concat($funderID, '::', normalize-space(.//FundingStream))" />	
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($funderID, '::UNKNOWN')" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="fundingID" select="normalize-space($fundingIDtemp)" />
	<xsl:variable name="projectID" select="concat($namespacePrefix, '::', .//Grant/Id)" />
	<xsl:variable name="orgID" select="concat($namespacePrefix, '::', translate(.//Institution, ' ,', '__'))" />
	<xsl:variable name="personID" select="concat($projectID, '::', translate(concat(.//PI/FirstName, ' ', .//PI/LastName), ' ,.', '___'))" />
	<xsl:variable name="startDate" select="translate(.//StartDate,'/\','--')" />
	<xsl:variable name="endDate" select="translate(.//EndDate,'/\','--')" />
	
	<xsl:variable name="dateFormat" select="string('dd-MM-yyyy')"/>

	<xsl:template match="/">
    	<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
			xmlns:dri="http://www.driver-repository.eu/namespace/dri"
			xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">

		<xsl:copy-of select=".//*[local-name()='header']"/>
		<metadata>
		<ROWS>
			<xsl:if test="string-length(normalize-space(.//Grant/Title)) &gt; 0 and string-length($projectID) &gt; 0">
				<ROW table="projects">
					<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectID" /></FIELD>
					<FIELD name="id"><xsl:value-of select="$projectID" /></FIELD>
					<FIELD name="code"><xsl:value-of select=".//Grant/Id"/></FIELD>
					<FIELD name="startdate" type="date" format="{$dateFormat}"><xsl:value-of select="$startDate" /></FIELD>
					<FIELD name="enddate" type="date" format="{$dateFormat}"><xsl:value-of select="$endDate" /></FIELD>
					<FIELD name="title"><xsl:value-of select=".//Grant/Title" /></FIELD>
					<FIELD name="contracttypeclass">UNKNOWN</FIELD>
					<FIELD name="contracttypescheme">wt:contractTypes</FIELD>
					<FIELD name="acronym"> </FIELD>
					<FIELD name="keywords"><xsl:value-of select=".//Grant/Type" /></FIELD>
					<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
					<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
					<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
					<FIELD name="optional1"><xsl:value-of select="concat(.//Grant/AmountAwarded, ' pounds')" /></FIELD>
				</ROW>
				<ROW table="project_fundingpath">
					<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($fundingID,'@@', $projectID)" /></FIELD>
					<FIELD name="funding"><xsl:value-of select="$fundingID" /></FIELD>
					<FIELD name="project"><xsl:value-of select="$projectID" /></FIELD>
					<FIELD name="startdate" type="date" format="{$dateFormat}"><xsl:value-of select="$startDate" /></FIELD>
					<FIELD name="enddate" type="date" format="{$dateFormat}"><xsl:value-of select="$endDate" /></FIELD>
				</ROW>
				<ROW table="persons">
					<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$personID" /></FIELD>
					<FIELD name="id"><xsl:value-of select="$personID" /></FIELD>
					<FIELD name="firstname"><xsl:value-of select=".//PI/FirstName" /></FIELD>
					<FIELD name="secondnames"><xsl:value-of select=".//PI/LastName" /></FIELD>
					<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
					<FIELD name="optional1"><xsl:value-of select=".//PI/Title" /></FIELD>
					<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
					<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
				</ROW>
				<xsl:if test="string-length($orgID) &gt; 4"> 
					<ROW table="organizations">
						<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$orgID" /></FIELD>
						<FIELD name="id"><xsl:value-of select="$orgID" /></FIELD>
						<FIELD name="legalshortname"><xsl:value-of select=".//Institution" /></FIELD>
						<FIELD name="legalname"><xsl:value-of select=".//Institution" /></FIELD>
						<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
						<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
						<FIELD name="trust" type="float">0.8</FIELD>
					</ROW>
					<ROW table="project_organization">
						<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($projectID, '@@', $orgID)" /></FIELD>
						<FIELD name="participantnumber" type="int">1</FIELD>
						<FIELD name="startdate" type="date" format="{$dateFormat}"><xsl:value-of select="$startDate" /></FIELD>
						<FIELD name="enddate" type="date" format="{$dateFormat}"><xsl:value-of select="$endDate" /></FIELD>
						<FIELD name="project"><xsl:value-of select="$projectID" /></FIELD>
						<FIELD name="resporganization"><xsl:value-of select="$orgID" /></FIELD>
						<FIELD name="contactperson"><xsl:value-of select="$personID" /></FIELD>
						<FIELD name="semanticclass">coordinator</FIELD>
						<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
					</ROW>
				</xsl:if>
			</xsl:if>
		</ROWS>
		</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>
