<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
	xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:dnet="eu.dnetlib.data.transform.xml.DmfToHbaseXsltFunctions"
	xmlns:exslt="http://exslt.org/common" xmlns:action="http://namespace.openaire.eu/action" 
	extension-element-prefixes="exslt"
	exclude-result-prefixes="xsl dc dr dri oaa oaf dnet exslt">

	<xsl:output omit-xml-declaration="yes" indent="yes" />

	<xsl:template match="/*">
	
		<xsl:variable name="provenance"><xsl:value-of select="//FIELD[@name = 'provenance']"/></xsl:variable>
		<xsl:variable name="trust">0.9</xsl:variable>

		<xsl:choose>
			<xsl:when test="count(//RELATION) = 0">
				<ROWS />
			</xsl:when>
			<xsl:otherwise>
				<ROWS>
					<xsl:for-each select="//RELATION">
						<xsl:choose>
							<xsl:when test="./@type = 'resultProject'">
								<xsl:variable name="resultId" select="./@source" />
								<xsl:variable name="projectId">
									<xsl:choose>
										<xsl:when test="starts-with(@target, '40|')">
											<xsl:value-of select="./@target" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="dnet:oafSplitId('project', normalize-space(@target))"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								
								<ROW key="{$resultId}" columnFamily="resultProject_outcome_isProducedBy">
									<QUALIFIER name="{$projectId}" type="base64"><xsl:value-of select="dnet:oafResultProject_Outcome_FromDMF($resultId, $projectId, 'isProducedBy', $provenance, $trust)"/></QUALIFIER>
								</ROW>
								<ROW key="{$projectId}" columnFamily="resultProject_outcome_produces">
									<QUALIFIER name="{$resultId}" type="base64"><xsl:value-of select="dnet:oafResultProject_Outcome_FromDMF($projectId, $resultId, 'produces', $provenance, $trust)"/></QUALIFIER>
								</ROW>
							</xsl:when>
							<xsl:when test="./@type = 'resultResult_publicationdataset_isRelatedTo'">
								<xsl:variable name="source" select="./@source" />
								<xsl:variable name="target" select="./@target" />

								<ROW key="{$source}" columnFamily="resultResult_publicationDataset_isRelatedTo">
									<QUALIFIER name="{$target}" type="base64"><xsl:value-of select="dnet:oafResultResult_PublicationDataset_FromDMF($source, $target, 'isRelatedTo', $provenance, $trust)"/></QUALIFIER>
								</ROW>
								<ROW key="{$target}" columnFamily="resultResult_publicationDataset_isRelatedTo">
									<QUALIFIER name="{$source}" type="base64"><xsl:value-of select="dnet:oafResultResult_PublicationDataset_FromDMF($target, $source, 'isRelatedTo', $provenance, $trust)"/></QUALIFIER>
								</ROW>
							</xsl:when>							
						</xsl:choose>
					</xsl:for-each>
				</ROWS>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	

</xsl:stylesheet>
