<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('irb_hr______')" />

	<xsl:template match="/">
		<fundingtree>
			<xsl:if test="contains(//column[@name='FUNDER_NAME'], 'MSES')">
				<funder>
					<id><xsl:value-of select="concat($namespacePrefix, '::MSES')" /></id>
					<shortname>MSES</shortname>
					<name>Ministry of Science, Education and Sports of the Republic of Croatia</name>
					<jurisdiction>HR</jurisdiction>
				</funder>
				<funding_level_0>
					<id><xsl:value-of select="concat($namespacePrefix, '::MSES::fundingStream')" /></id>
					<name>Ministry of Science, Education and Sports of the Republic of Croatia - Funding Stream</name>
					<description>Ministry of Science, Education and Sports of the Republic of Croatia - Funding Stream</description>
					<parent />
					<class>mses:fundingStream</class>
				</funding_level_0>
			</xsl:if>
		</fundingtree>

	</xsl:template>

</xsl:stylesheet>
