<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
	xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:ands="http://ands.org.au/standards/rif-cs/registryObjects">
	
	<xsl:output indent="yes"/>
	
	<xsl:param name="parentDatasourceId" />
		
	<xsl:template match="/">
		<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
			xmlns:dri="http://www.driver-repository.eu/namespace/dri"
			xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">
			
			<xsl:copy-of select=".//*[local-name()='header']"/>
			
			<metadata>
				<ROWS>
					<xsl:for-each select="//ands:registryObject[@group='Australian Research Council']/ands:activity[@type='grant']">
						<xsl:variable name="projectId" select="concat('arc_________::', normalize-space(./ands:identifier[@type='arc']))"/>
						<xsl:variable name="fundingId" select="concat('arc_________::ARC::', normalize-space(./ands:description[@type='fundingScheme']))"/>
						
						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="code"><xsl:value-of select="normalize-space(.//ands:identifier[@type='arc'])" /></FIELD>
							<FIELD name="title"><xsl:value-of select="./ands:name[@type='primary']/ands:namePart" /></FIELD>
							<FIELD name="websiteurl"><xsl:value-of select="./ands:identifier[@type='purl']"/></FIELD>
							
							<xsl:for-each select="./ands:existenceDates/ands:startDate[@dateFormat='W3CDTF']">
								<FIELD name="startdate" type="date" format="dd-MM-yyyy"><xsl:value-of select="concat('01-01-', normalize-space(.))" /></FIELD>
							</xsl:for-each>
							<xsl:for-each select="./ands:existenceDates/ands:endDate[@dateFormat='W3CDTF']">
								<FIELD name="enddate" type="date" format="dd-MM-yyyy"><xsl:value-of select="concat('31-12-', normalize-space(.))" /></FIELD>
							</xsl:for-each>
							
							<xsl:variable name="keywords">
								<xsl:for-each select="./ands:subject[@type='local']">
									<xsl:if test="position() != 1">, </xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:variable>
							<FIELD name="keywords"><xsl:value-of select="normalize-space($keywords)" /></FIELD>
							<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
						</ROW>
						
						<ROW table="project_fundingpath">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($fundingId, '@@', $projectId)" /></FIELD>
							<FIELD name="funding"><xsl:value-of select="$fundingId" /></FIELD>
							<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
							<xsl:for-each select="./ands:existenceDates/ands:startDate[@dateFormat='W3CDTF']">
								<FIELD name="startdate" type="date" format="dd-MM-yyyy"><xsl:value-of select="concat('01-01-', normalize-space(.))" /></FIELD>
							</xsl:for-each>
							<xsl:for-each select="./ands:existenceDates/ands:endDate[@dateFormat='W3CDTF']">
								<FIELD name="enddate" type="date" format="dd-MM-yyyy"><xsl:value-of select="concat('31-12-', normalize-space(.))" /></FIELD>
							</xsl:for-each>
						</ROW>
					
					</xsl:for-each>
				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>
