package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import java.util.Map;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import com.google.common.collect.Maps;

public class ContextDesc {

	private String id;
	private String label;
	private String type;
	private String xml;
	private Map<String, ContextPart> categories = Maps.newLinkedHashMap();
	private Map<String, String> dbEntries = Maps.newLinkedHashMap();

	public ContextDesc(final String id, final String label, final String type) {
		this.id = id;
		this.label = label;
		this.type = type;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(final String label) {
		this.label = label;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getXml() {
		return xml;
	}

	public void setXml(final String xml) {
		this.xml = xml;
	}

	public Map<String, ContextPart> getCategories() {
		return categories;
	}

	public void setCategories(final Map<String, ContextPart> categories) {
		this.categories = categories;
	}

	public Map<String, String> getDbEntries() {
		return dbEntries;
	}

	public void setDbEntries(final Map<String, String> dbEntries) {
		this.dbEntries = dbEntries;
	}

	public Element asDomElement() {
		final Element ctxElem = DocumentHelper.createElement("context");
		ctxElem.addAttribute("id", getId());
		ctxElem.addAttribute("label", getLabel());
		ctxElem.addAttribute("type", getType());

		for (ContextPart part : getCategories().values()) {
			ctxElem.add(part.asDomElement("category"));
		}

		return ctxElem;
	}

}
