package eu.dnetlib.msro.openaireplus.workflows.nodes.stats;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;

/**
 * Ask the StatsManagerService to perform the content validation between the shadow stats db and the preproduction index (using the
 * prepublic search service) and creates a report, which is serialized in the blackboard job parameters.
 * <p>
 * The report is relative to the shadow stats db related to the portal specified by the additional BB parameter
 * <code>StatsManagerServiceBBAction.VALIDATE_SHADOW_STATS.getTargetPortalParamName()</code>
 * </p>
 * 
 * @author alessia
 * 
 */
public class ValidateShadowStatsJobNode extends AbstractStatsJobNode {

	private static final Log log = LogFactory.getLog(ValidateShadowStatsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.VALIDATE_SHADOW_STATS.action());
		String portal = getPortalName(token);
		if (StringUtils.isNotBlank(portal)) {
			job.getParameters().put(StatsManagerServiceBBAction.VALIDATE_SHADOW_STATS.getTargetPortalParamName(), portal);
		} else {
			log.warn(StatsManagerServiceBBAction.VALIDATE_SHADOW_STATS.getTargetPortalParamName() + " not set. The StatsManagerService will use its default.");
		}

	}

}
