<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
	xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="xs" version="1.0">

	<xsl:param name="parentDatasourceId" />
	<xsl:param name="namespacePrefix" />
	
	<xsl:template match="/">

		<xsl:variable name="prefix" select="string('sfi_________')" />

		<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
			xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:dc="http://purl.org/dc/elements/1.1/"
			xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:oaf="http://namespace.openaire.eu/oaf"
			xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">

			<xsl:copy-of select=".//*[local-name()='header']" />

			<metadata>
				<ROWS>
					<xsl:if test="normalize-space(.//column[@name='Project Identifier']) and normalize-space(.//column[@name='Project Title'])">
						<xsl:variable name="projectId" select="concat($namespacePrefix, '::',  normalize-space(.//column[@name='Project Identifier']))" />
						<xsl:variable name="startDate" select=".//column[@name='Start date']" />
						<xsl:variable name="endDate" select=".//column[@name='End Date']" />
						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="code"><xsl:value-of select=".//column[@name='Project Identifier']" /></FIELD>
							<FIELD name="title"><xsl:value-of select=".//column[@name='Project Title']" /></FIELD>
							<FIELD name="startdate" type="date" format="dd/MM/yyyy"><xsl:value-of select="$startDate" /></FIELD>
							<FIELD name="enddate" type="date" format="dd/MM/yyyy"><xsl:value-of select="$endDate" /></FIELD>
							<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
							<FIELD name="provenanceactionclass">sysimport:crosswalk:entityregistry</FIELD>
						</ROW>
						
						<xsl:if test="normalize-space(.//column[@name='Programme'])">
							<xsl:variable name="funderId" select="concat($prefix, '::SFI')" />
							<xsl:variable name="fundingId" select="concat($funderId, '::', normalize-space(.//column[@name='Programme']))" />
							<ROW table="project_fundingpath">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($fundingId, '@@', $projectId)" /></FIELD>
								<FIELD name="funding"><xsl:value-of select="$fundingId" /></FIELD>
								<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
								<FIELD name="startdate" type="date" format="dd/MM/yyyy"><xsl:value-of select="$startDate" /></FIELD>
								<FIELD name="enddate" type="date" format="dd/MM/yyyy"><xsl:value-of select="$endDate" /></FIELD>
							</ROW>
						</xsl:if>
	
						<xsl:if test="normalize-space(.//column[@name='Research Body'])">
							<xsl:variable name="organizationId"	select="concat($namespacePrefix, '::', normalize-space(.//column[@name='Research Body']))" />
							<ROW table="organizations">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$organizationId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$organizationId" /></FIELD>
								<FIELD name="legalshortname"><xsl:value-of select=".//column[@name='Research Body']" /></FIELD>
								<FIELD name="legalname"><xsl:value-of select=".//column[@name='Research Body']" /></FIELD>
								<FIELD name="countryclass">IE</FIELD>
								<FIELD name="countryscheme">dnet:countries</FIELD>
								<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
								<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
								<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							</ROW>
							<ROW table="project_organization">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select='concat($projectId, "@@", $organizationId)' /></FIELD>
								<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
								<FIELD name="resporganization"><xsl:value-of select="$organizationId" /></FIELD>
								<FIELD name="participantnumber" type="int">1</FIELD>
								<FIELD name="semanticclass">coordinator</FIELD>
								<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
							</ROW>
						</xsl:if>
					</xsl:if>	
				</ROWS>
			</metadata>
		</record>
	</xsl:template>

</xsl:stylesheet>
