package eu.dnetlib.msro.openaireplus.workflows.nodes;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

/**
 * The Class SetHdfsFileJobNode.
 */
public class SetHdfsFileJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(SetHdfsFileJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/** The input records path. */
	private String hdfsPath;

	/** The input records path param. */
	private String hdfsPathParam;

	/**
	 * {@inheritDoc}
	 * 
	 * @see com.googlecode.sarasvati.mem.MemNode#execute(com.googlecode.sarasvati.Engine, com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	public String execute(final NodeToken token) {

		log.info("hdfs path: " + getHdfsPath());

		token.getEnv().setAttribute(getHdfsPathParam(), getHdfsPath());

		return Arc.DEFAULT_ARC;
	}

	public String getHdfsPath() {
		return hdfsPath;
	}

	public void setHdfsPath(final String hdfsPath) {
		this.hdfsPath = hdfsPath;
	}

	public String getHdfsPathParam() {
		return hdfsPathParam;
	}

	public void setHdfsPathParam(final String hdfsPathParam) {
		this.hdfsPathParam = hdfsPathParam;
	}

}
