CREATE TYPE IIS_STATUS AS ENUM ('unsolved', 'solved');
CREATE TYPE STATUS AS ENUM ('pending', 'accepted', 'refused', 'deleted');

CREATE TABLE blacklist (

	id SERIAL PRIMARY KEY,
	userid character varying(255) NOT NULL,
	semantic_class character varying(255) NOT NULL,
	semantic_scheme character varying(255) NOT NULL,
	hbase_relation_type_encoding character varying(255) NOT NULL,
	provenance character varying(255) NOT NULL,
	iis_module character varying(255) NOT NULL,
	iis_module_profile character varying(255),
	
	iis_status IIS_STATUS NOT NULL,
	status STATUS NOT NULL,

	source_object character varying(255) NOT NULL,
	target_object character varying(255) NOT NULL,

	original_source_objects character varying(255) ARRAY,
	original_target_objects character varying(255) ARRAY,

	creation_time timestamp default now(),
	last_update_time timestamp default now(),
	
	note text,
	ticket_id character varying(255)
);

CREATE INDEX ON blacklist(source_object);
CREATE INDEX ON blacklist(target_object);
CREATE INDEX ON blacklist(ticket_id);
CREATE INDEX ON blacklist(iis_status);
CREATE INDEX ON blacklist(status);

-- https://issue.openaire.research-infrastructures.eu/issues/1245
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id) 
			VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects', 'unsolved', 'accepted', 'od_______908::a47e1c3ede9a21ee5278a2e5c338d69b', 'corda_______::fda6a1c19dac47508b6fb619518328c7', '1245');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id) 
			VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects', 'unsolved', 'accepted', 'od_______908::a47e1c3ede9a21ee5278a2e5c338d69b', 'corda_______::189ff31d637eaaeaf4d3584dc490b1cf', '1245');
			
-- https://issue.openaire.research-infrastructures.eu/issues/1360			
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id) 
			VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects', 'unsolved', 'accepted', 'od________18::a727cc288016db7132ef9a799aa83350', 'corda_______::9826e8aba3e8f3a2a46545cf341838a8', '1360');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id) 
			VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects', 'unsolved', 'accepted', 'od________18::062cf091d5c7a7d730001c34177042e3', 'corda_______::9826e8aba3e8f3a2a46545cf341838a8', '1360');

-- https://issue.openaire.research-infrastructures.eu/issues/1254
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects', 'solved',
			 'accepted', 'webcrawl____::68c191d9b972b47a235d311804c7f6f5', 'corda_______::c3d0b21615b129cd7395e24f9cf6bb64', '1254');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'od_______908::1b172ab34639e7935e2357119cf20830', 'corda_______::c3d0b21615b129cd7395e24f9cf6bb64', '1254');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'doajarticles::cb234c66327d29ba5f13c0db7a4cf423', 'corda_______::c3d0b21615b129cd7395e24f9cf6bb64', '1254');

-- https://issue.openaire.research-infrastructures.eu/issues/1297
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects', 'unsolved',
			 'accepted', 'od______1146::e2fafaba636a14e408f02c6ea26acb0e', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'od_______908::b8e86ed982ff331764456e1f0759ed9c', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'webcrawl____::c472bf5944ce0495844d505d43d1c021', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'od_______908::bbe86580e44dbefa401d435259baddf1', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'webcrawl____::ae0ae3ea5641ac24fa148ac38397dfcd', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'webcrawl____::5f46a8c6420f5b5eaf30d7212b0ada5b', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'od_______908::49d9b3df9cf7e9c991e09e53677e40e3', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'od_______330::aa2edd06a6121a1a1db63be83cd7b7c7', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'od_______908::45f342e6f10d5543631a757b417388d7', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'webcrawl____::6ce2789da52c6036501533ed5613d71a', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'od_______908::bbe86580e44dbefa401d435259baddf1', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'webcrawl____::f887afc3d7a8e8c708b9b773d26cdd9d', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'webcrawl____::161ee67349e268750701ee437188340b', 'corda_______::35695c955c51f0bb39482ce5477047c7', '1297');

-- https://issue.openaire.research-infrastructures.eu/issues/1360
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'od________18::a727cc288016db7132ef9a799aa83350', 'corda_______::9826e8aba3e8f3a2a46545cf341838a8', '1360');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'od________18::062cf091d5c7a7d730001c34177042e3', 'corda_______::9826e8aba3e8f3a2a46545cf341838a8', '1360');

-- https://issue.openaire.research-infrastructures.eu/issues/1412
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id)
VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects',
			 'unsolved', 'accepted', 'od______2367::eb76f733498920166d4ce77ec37d487c', 'corda_______::800e636c0a24ac3767701a789a96ba89', '1360');

