<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:template match="/">
		<fundings>
			<xsl:for-each select="//funding">
				<fundingtree>
					<funder>
						<id>ands________::NHMRC</id>
						<shortname>NHMRC</shortname>
						<name>National Health and Medical Research Council (NHMRC)</name>
						<jurisdiction>AU</jurisdiction>
					</funder>
					<funding_level_3>
						<id><xsl:value-of select="concat('ands________::NHMRC::', ./mainFundingGroup, '::', ./higherGrantType, '::', ./subType)" /></id>
						<description><xsl:value-of select="./subType" /></description>
						<name><xsl:value-of select="./subType" /></name>
						<class>ands:fundingStream</class>
						<funding_level_2>
							<id><xsl:value-of select="concat('ands________::NHMRC::', ./mainFundingGroup, '::', ./higherGrantType)" /></id>
							<description><xsl:value-of select="./higherGrantType" /></description>
							<name><xsl:value-of select="./higherGrantType" /></name>
							<class>ands:fundingStream</class>
							<funding_level_1>
								<id><xsl:value-of select="concat('ands________::NHMRC::', ./mainFundingGroup)" /></id>
								<description><xsl:value-of select="./mainFundingGroup" /></description>
								<name><xsl:value-of select="./mainFundingGroup" /></name>
								<class>ands:fundingStream</class>
								<parent>
									<funding_level_0>
										<id>ands________::NHMRC</id>
										<description>National Health and Medical Research Council Funding Stream</description>
										<name>NHMRC</name>
										<parent></parent>
										<class>ands:fundingStream</class>
									</funding_level_0>
								</parent>
							</funding_level_1>
						</funding_level_2>
					</funding_level_3>
					
				</fundingtree>
			</xsl:for-each>
		</fundings>
	</xsl:template>
</xsl:stylesheet>
