<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
	xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	
	<xsl:param name="parentDatasourceId" />

	<xsl:variable name="invalid" select="' ,-'" />
	<xsl:variable name="valid"   select="'___'" />
		
	<xsl:template match="/">
		<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
			xmlns:dri="http://www.driver-repository.eu/namespace/dri"
			xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">
			
			<xsl:copy-of select=".//*[local-name()='header']"/>
			
			<metadata>
				<ROWS>
					<xsl:variable name="prefix" select="string('arc_________')" />
					<xsl:variable name="projectId" select="concat($prefix, '::',  //project/id)" />
					<xsl:variable name="parentDatasourceId" select="string('openaire____::arc')"/>
					<xsl:variable name="startDate" select="//project/startDate" />
					<xsl:variable name="endDate" select="//project/endDate" />
									
					<ROW table="projects">
						<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectId" /></FIELD>
						<FIELD name="id"><xsl:value-of select="$projectId" /></FIELD>
						<FIELD name="code"><xsl:value-of select="//project/id" /></FIELD>
						<FIELD name="title"><xsl:value-of select="//project/title" /></FIELD>
						<xsl:if test="normalize-space($startDate)">
							<FIELD name="startdate" type="date" format="dd-MM-yyyy"><xsl:value-of select="$startDate" /></FIELD>
						</xsl:if>
						<xsl:if test="normalize-space($endDate)">
							<FIELD name="enddate" type="date" format="dd-MM-yyyy"><xsl:value-of select="$endDate" /></FIELD>
						</xsl:if>
						<FIELD name="keywords"><xsl:value-of select="//project/keywords" /></FIELD>
						<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId"/></FIELD>
						<FIELD name="provenanceactionclass">sysimport:crosswalk:entityregistry</FIELD>
					</ROW>
					
					<xsl:for-each select="//organisation">
						<xsl:variable name="orgId" select="concat($prefix,'::',.)"/>					
						<ROW table="organizations">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$orgId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$orgId" /></FIELD>
							<FIELD name="legalname"><xsl:value-of select="." /></FIELD>
							<FIELD name="countryclass">AU</FIELD>
						</ROW>
						<ROW table="project_organization">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($projectId,'@@',$orgId)" /></FIELD>
							<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="resporganization"><xsl:value-of select="$orgId" /></FIELD>
							<FIELD name="participantnumber" type="int">1</FIELD>
							<xsl:if test="normalize-space($startDate)">
								<FIELD name="startdate" type="date" format="dd-MM-yyyy"><xsl:value-of select="$startDate" /></FIELD>
							</xsl:if>
							<xsl:if test="normalize-space($endDate)">
								<FIELD name="enddate" type="date" format="dd-MM-yyyy"><xsl:value-of select="$endDate" /></FIELD>
							</xsl:if>
						</ROW>
					</xsl:for-each>
					
					<xsl:for-each select="//funding">
						<xsl:variable name="fundingId" select="concat('arc_________::ARC::', ./id)" />
						<ROW table="project_fundingpath">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($fundingId, '@@', $projectId)" /></FIELD>
							<FIELD name="funding"><xsl:value-of select="$fundingId" /></FIELD>
							<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
							<xsl:if test="normalize-space($startDate)">
								<FIELD name="startdate" type="date" format="dd-MM-yyyy"><xsl:value-of select="$startDate" /></FIELD>
							</xsl:if>
							<xsl:if test="normalize-space($endDate)">
								<FIELD name="enddate" type="date" format="dd-MM-yyyy"><xsl:value-of select="$endDate" /></FIELD>
							</xsl:if>
						</ROW>
					</xsl:for-each>
					
				</ROWS>
			</metadata>
		</record>
	</xsl:template>

</xsl:stylesheet>
