<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:template match="/">
		<xsl:variable name="funding">
			<xsl:choose>
				<xsl:when test="normalize-space(.//FundingStream)">
					<xsl:value-of select="normalize-space(.//FundingStream)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="string('UNKNOWN')" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<fundingtree>
			<funder>
				<id>wt__________::WT</id>
				<shortname>WT</shortname>
				<name>Wellcome Trust</name>
				<jurisdiction></jurisdiction>
			</funder>
			<funding_level_1>
				<id><xsl:value-of select="concat('wt__________::WT::', $funding)" /></id>
				<description><xsl:value-of select="$funding" /></description>
				<name><xsl:value-of select="$funding" /></name>
				<class>wt:fundingStream</class>
				<parent>
					<funding_level_0>
						<id>wt__________::WT</id>
						<description>Wellcome Trust Funding Stream</description>
						<name>WT</name>
						<parent></parent>
						<class>wt:fundingStream</class>
					</funding_level_0>
				</parent>
			</funding_level_1>
		</fundingtree>
	</xsl:template>

</xsl:stylesheet>
