/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.datacite;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.collector.plugins.datasets.DatasetsByJournalIterator;
import eu.dnetlib.data.collector.plugins.datasets.PangaeaJournalInfo;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.openaireplus.workflows.nodes.datacite.IteratorOnQueue;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class CollectDatasetsByJournalJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(CollectDatasetsByJournalJobNode.class);
    public static PangaeaJournalInfo END_QUEUE = new PangaeaJournalInfo();
    private String datasourceId;
    private String outputEprParam;
    private String inputEprParam;
    private ResultSetClientFactory resultSetClientFactory;
    @Resource(name="iterableResultSetFactory")
    private IterableResultSetFactory resultSetFactory;
    private Executor executor = Executors.newSingleThreadExecutor();

    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(this.inputEprParam));
        IterableResultSetClient input = this.resultSetClientFactory.getClient(inputEpr);
        ArrayBlockingQueue publicationsQueue = new ArrayBlockingQueue(50);
        this.executor.execute(new Runnable((Iterable)input, publicationsQueue){
            final /* synthetic */ Iterable val$input;
            final /* synthetic */ BlockingQueue val$publicationsQueue;
            {
                this.val$input = iterable;
                this.val$publicationsQueue = blockingQueue;
            }

            @Override
            public void run() {
                SAXReader reader = new SAXReader();
                for (String inputString : this.val$input) {
                    try {
                        Document doc = reader.read((Reader)new StringReader(inputString));
                        String jId = doc.valueOf("//FIELD[@name='id']");
                        String dsId = doc.valueOf("//FIELD[@name='datasource']");
                        String dsName = doc.valueOf("//FIELD[@name='name']");
                        String jISSN = doc.valueOf("//FIELD[@name='issn']");
                        PangaeaJournalInfo info = new PangaeaJournalInfo();
                        info.setDatasourceId(dsId);
                        info.setJournalId(jId);
                        info.setJournalName(dsName);
                        info.setJournalISSN(jISSN);
                        this.val$publicationsQueue.put(info);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                try {
                    this.val$publicationsQueue.put(END_QUEUE);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            }
        });
        IteratorOnQueue<PangaeaJournalInfo> itOnQueue = new IteratorOnQueue<PangaeaJournalInfo>(publicationsQueue, END_QUEUE);
        W3CEndpointReference eprOutput = this.resultSetFactory.createIterableResultSet((Iterable)new DatasetsByJournalIterator(itOnQueue));
        token.getEnv().setAttribute(this.getOutputEprParam(), eprOutput.toString());
        return Arc.DEFAULT_ARC;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }
}

