/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby.HostedByCounters;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class FindHostedByJobNode
extends SimpleJobNode {
    private String inputEprParam;
    private String outputEprParam;
    private String countersParam;
    private ResultSetClientFactory resultSetClientFactory;
    private MappedResultSetFactory mappedResultSetFactory;
    private final String unknown_repo_id = "openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18";

    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(this.inputEprParam));
        final HostedByCounters counters = new HostedByCounters();
        final SAXReader reader = new SAXReader();
        UnaryFunction<String, String> hostedByMapFunction = new UnaryFunction<String, String>(){

            public String evaluate(String input) {
                try {
                    String hostedById;
                    Document doc = reader.read((Reader)new StringReader(input));
                    Element node = (Element)doc.selectSingleNode("//*[local-name()='hostedBy']");
                    if (node != null && !(hostedById = node.attributeValue("id")).equals("openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18")) {
                        counters.increaseCounter(hostedById);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return input;
            }
        };
        W3CEndpointReference epr = this.mappedResultSetFactory.createMappedResultSet(inputEpr, (UnaryFunction)hostedByMapFunction);
        token.getEnv().setAttribute(this.outputEprParam, epr.toString());
        token.getEnv().setTransientAttribute(this.getCountersParam(), (Object)counters);
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public MappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }

    public String getCountersParam() {
        return this.countersParam;
    }

    public void setCountersParam(String countersParam) {
        this.countersParam = countersParam;
    }
}

