/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.nodes.download.DownloadFromMetadataJobNode;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadFromMetadataOpenaire
extends DownloadFromMetadataJobNode {
    private static final Log log = LogFactory.getLog(DownloadFromMetadataOpenaire.class);
    private String basepath;

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        if (this.getBasepath() != null && this.getBasepath().length() > 0) {
            job.getParameters().put("basePath", this.basepath);
        }
        super.prepareJob(job, token);
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            protected void populateEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute("mainlog:total", responseParams.get("total"));
                String base64 = responseParams.get("report");
                if (StringUtils.isNotBlank((String)base64) && Base64.isBase64((byte[])base64.getBytes())) {
                    String report = new String(Base64.decodeBase64((byte[])base64.getBytes()));
                    log.info((Object)"found download report");
                    log.debug((Object)report);
                    env.setAttribute("mainlog:report", report);
                } else {
                    log.warn((Object)"unable to find or decode download report");
                }
            }
        };
    }

    public String getBasepath() {
        return this.basepath;
    }

    public void setBasepath(String basepath) {
        this.basepath = basepath;
    }
}

