<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="xs" version="2.0">

    <xsl:param name="parentDatasourceId"/>
    <xsl:param name="namespacePrefix"/>

    <xsl:variable name="invalid" select="' ,-'"/>
    <xsl:variable name="valid" select="'___'"/>

    <xsl:variable name="prefix" select="string('fct_________')"/>
    <xsl:variable name="funderID" select="concat($prefix, '::FCT')"/>

    <xsl:template match="/">
        <record>
            <xsl:copy-of select=".//*[local-name()='header']"/>
            <metadata>
                <ROWS>
                    <xsl:for-each select="//project">
                        <xsl:call-template name="projectTemplate"/>
                    </xsl:for-each>
                </ROWS>
            </metadata>

        </record>
    </xsl:template>

    <xsl:template name="projectTemplate">

        <xsl:variable name="projectId" select="concat($namespacePrefix, '::',  ./id)"/>
        <xsl:variable name="projectAcronym" select="./reference"/>
        <xsl:variable name="tokens" select="tokenize(./reference,'/')"/>
        <xsl:variable name="callID" select="concat($tokens[1], '/', $tokens[last()])"/>

        <ROW table="projects">
            <FIELD name="_dnet_resource_identifier_">
                <xsl:value-of select="$projectId"/>
            </FIELD>
            <FIELD name="id">
                <xsl:value-of select="$projectId"/>
            </FIELD>
            <FIELD name="code">
                <xsl:value-of select="./id"/>
            </FIELD>
            <FIELD name="call_identifier">
                <xsl:value-of select="$callID"/>
            </FIELD>
            <FIELD name="websiteurl">
                <xsl:value-of select="./refUri"/>
            </FIELD>
            <FIELD name="acronym">
                <xsl:value-of select="./reference"/>
            </FIELD>
            <FIELD name="title">
                <xsl:value-of select="./name"/>
            </FIELD>
            <FIELD name="startdate" type="date" format="dd/MM/yyyy">
                <xsl:value-of select="./startDate"/>
            </FIELD>
            <FIELD name="enddate" type="date" format="dd/MM/yyyy">
                <xsl:value-of select="./endDate"/>
            </FIELD>
            <FIELD name="keywords">
                <xsl:for-each select="./classification/elem">
                    <xsl:if test="position() &gt; 1">,</xsl:if>
                    <xsl:value-of select="."/>
                </xsl:for-each>
            </FIELD>
            <FIELD name="collectedfrom">
                <xsl:value-of select="$parentDatasourceId"/>
            </FIELD>
            <FIELD name="contracttypeclass">UNKNOWN</FIELD>
            <FIELD name="contracttypescheme">fct:contractTypes</FIELD>
            <FIELD name="provenanceactionclass">sysimport:crosswalk:entityregistry</FIELD>
            <xsl:if test="string-length(normalize-space(./oaMandate)) &gt; 0">
                <FIELD name="oa_mandate_for_publications" type="boolean">
                    <xsl:value-of select="./oaMandate"/>
                </FIELD>
            </xsl:if>
        </ROW>

        <!--
        <xsl:for-each select="./persons/elem">
            <xsl:if test="string-length(./name) &gt; 0 and string-length(./researcherId) &gt; 0">

                <xsl:variable name="orgId" select="concat($projectId, '::', translate(./organization, $invalid, $valid))" />
                <ROW table="organizations">
                    <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$orgId" /></FIELD>
                    <FIELD name="id"><xsl:value-of select="$orgId" /></FIELD>
                    <FIELD name="legalname"><xsl:value-of select="./organization" /></FIELD>
                    <FIELD name="countryclass"><xsl:value-of select="./country" /></FIELD>
                    <FIELD name="countryscheme">dnet:countries</FIELD>
                    <FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
                    <FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
                    <FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
                </ROW>
                <xsl:variable name="personId" select="concat($projectId, '::', ./researcherId)"/>
                <ROW table="persons">
                    <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$personId" /></FIELD>
                    <FIELD name="id"><xsl:value-of select="$personId" /></FIELD>
                    <FIELD name="firstname"><xsl:value-of select="./name" /></FIELD>
                    <FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
                    <FIELD name="nationalityClass"><xsl:value-of select="./country" /></FIELD>
                    <FIELD name="nationalityScheme">dnet:countries</FIELD>
                    <FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
                    <FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
                    <FIELD name="optional1"><xsl:value-of select="./role" /></FIELD>
                </ROW>
                <ROW table="project_organization">
                    <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($orgId, '@@', $projectId)" /></FIELD>
                    <FIELD name="participantnumber" type="int"><xsl:value-of select="position()" /></FIELD>
                    <FIELD name="startdate" type="date" format="dd/MM/yyyy"><xsl:value-of select="../../startDate"/></FIELD>
                    <FIELD name="enddate" type="date" format="dd/MM/yyyy"><xsl:value-of select="../../endDate"/></FIELD>
                    <FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
                    <FIELD name="resporganization"><xsl:value-of select="$orgId" /></FIELD>
                    <FIELD name="contactperson"><xsl:value-of select="$personId" /></FIELD>
                    <FIELD name="semanticclass">participant</FIELD>
                </ROW>
                <ROW table="identities">
                    <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="./researcherId" /></FIELD>
                    <FIELD name="pid"><xsl:value-of select="./researcherId" /></FIELD>
                    <FIELD name="issuertypeclass">fct:researcher_ids</FIELD>
                    <FIELD name="issuertypescheme">dnet:pid_types</FIELD>
                </ROW>
                <ROW table="personpids">
                    <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat(./researcherId, '@@', $personId)" /></FIELD>
                    <FIELD name="pid"><xsl:value-of select="./researcherId" /></FIELD>
                    <FIELD name="person"><xsl:value-of select="$personId" /></FIELD>
                </ROW>
                <xsl:if test="string-length(normalize-space(./orcidId)) &gt; 0">
                    <ROW table="identities">
                        <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="./orcidId" /></FIELD>
                        <FIELD name="pid"><xsl:value-of select="./orcidId" /></FIELD>
                        <FIELD name="issuertypeclass">orcid</FIELD>
                        <FIELD name="issuertypescheme">dnet:pid_types</FIELD>
                    </ROW>
                    <ROW table="personpids">
                        <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat(./orcidId, '@@', $personId)" /></FIELD>
                        <FIELD name="pid"><xsl:value-of select="./orcidId" /></FIELD>
                        <FIELD name="person"><xsl:value-of select="$personId" /></FIELD>
                    </ROW>
                </xsl:if>
            </xsl:if>
        </xsl:for-each>
        -->

        <xsl:for-each select="./funding">
            <xsl:variable name="fundingName" select="normalize-space(./program)"/>

            <xsl:if test="string-length($fundingName) &gt; 0">
                <xsl:variable name="fundingId" select="concat($funderID,'::',$fundingName)"/>
                <ROW table="project_fundingpath">
                    <FIELD name="_dnet_resource_identifier_">
                        <xsl:value-of select="concat($fundingId, '@@', $projectId)"/>
                    </FIELD>
                    <FIELD name="funding">
                        <xsl:value-of select="$fundingId"/>
                    </FIELD>
                    <FIELD name="project">
                        <xsl:value-of select="$projectId"/>
                    </FIELD>
                    <FIELD name="startdate" type="date" format="dd/MM/yyyy">
                        <xsl:value-of select="../startDate"/>
                    </FIELD>
                    <FIELD name="enddate" type="date" format="dd/MM/yyyy">
                        <xsl:value-of select="../endDate"/>
                    </FIELD>
                    <FIELD name="optional1">
                        <xsl:value-of select="./amount"/>
                    </FIELD>
                    <FIELD name="optional2">
                        <xsl:value-of select="./dateAwarded"/>
                    </FIELD>
                </ROW>
            </xsl:if>
        </xsl:for-each>

    </xsl:template>
</xsl:stylesheet>
