package eu.dnetlib.msro.openaireplus.workflows.nodes.dataFlowMonitoring;

import java.io.IOException;
import javax.annotation.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.monitoring.core.sensors.SensorCreationException;
import eu.dnetlib.monitoring.core.sensors.SensorFactory;
import eu.dnetlib.monitoring.core.sensors.collection.index.solr.SolrSensor;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TriggerIndexMonitoringScenarioJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(TriggerIndexMonitoringScenarioJobNode.class);
	private static final String SOLR_COLLECTION_POSTFIX = "-index-openaire";

	@Resource
	private UniqueServiceLocator serviceLocator;
	private String mdFormat;
	private SolrSensor solrSensor;

	@Override
	protected String execute(final NodeToken token) throws IOException, InstantiationException, IllegalAccessException, InterruptedException,
			ISLookUpException, SensorCreationException {

		/* Configuring SOLR sensor */
		String actualCollection = mdFormat + SOLR_COLLECTION_POSTFIX;
		log.info("Executing on " + actualCollection + " SOLR collection");
		solrSensor = (SolrSensor) SensorFactory.createSensorWithConfiguration(SolrSensor.class, "index", "solr2");
		solrSensor.getConfiguration().setParam("collection", actualCollection);
		solrSensor.reinitialize();
		log.info("Measuring...");
		solrSensor.measure();
		log.info("DONE!");
		return Arc.DEFAULT_ARC;
	}

	public String getMdFormat() {
		return mdFormat;
	}

	public void setMdFormat(final String mdFormat) {
		this.mdFormat = mdFormat;
	}

}
