package eu.dnetlib.msro.openaireplus.workflows.nodes;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class OpenaireMdBuilderJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(OpenaireMdBuilderJobNode.class);

	private StringTemplate mdBuilderTemplateXslt;

	private String inputEprParam;
	private String outputEprParam;
	private String datasourceId;
	private String datasourceInterface;

	private boolean inferred = false;
	private boolean deletedbyinference = false;
	private String inferenceprovenance = "";
	private String trust = "";
	private String provenanceactionclassname = "";
	private String provenanceactionclassid = "";

	private String overridingMetadataIdentifierXPath = "";

	private XSLTMappedResultSetFactory xsltMappedResultSetFactory;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final NodeToken token) throws MSROException {
		final String inputEpr = token.getEnv().getAttribute(inputEprParam);

		if ((inputEpr == null) || inputEpr.isEmpty()) throw new MSROException("InputEprParam (" + inputEprParam + ") not found in ENV");

		try {
			final StringTemplate st = new StringTemplate(getMdBuilderTemplateXslt().getTemplate());

			st.setAttribute("xpath", getMetadataIdentifierXPath());
			st.setAttribute("datasourceId", datasourceId);
			if (token.getEnv().hasAttribute("namespacePrefix")) {
				st.setAttribute("namespacePrefix", token.getEnv().getAttribute("namespacePrefix"));
			} else {
				st.setAttribute("namespacePrefix", datasourceId);
			}

			st.setAttribute("inferred", String.valueOf(getInferred()));
			st.setAttribute("deletedbyinference", String.valueOf(getDeletedbyinference()));
			st.setAttribute("inferenceprovenance", getInferenceprovenance());
			st.setAttribute("trust", getTrust());
			st.setAttribute("provenanceactionclassname", getProvenanceactionclassname());
			st.setAttribute("provenanceactionclassid", getProvenanceactionclassid());
			st.setAttribute("baseurl", getBaseUrl());
			st.setAttribute("metadatanamespace", getMetadataNamespace());

			final W3CEndpointReference epr = xsltMappedResultSetFactory.createMappedResultSet(new EPRUtils().getEpr(inputEpr), st.toString());

			token.getEnv().setAttribute(outputEprParam, epr.toString());

			return Arc.DEFAULT_ARC;
		} catch (ISLookUpException e) {
			throw new MSROException("Error while initializing mdBuilder template for datasource " + datasourceId, e);
		}
	}

	private String getMetadataIdentifierXPath() throws ISLookUpException {
		String xQuery =
				String.format("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') "
						+ "return $x//INTERFACE[@id='%s']/INTERFACE_EXTRA_FIELD[@name='metadata_identifier_path']/string()", getDatasourceInterface());

		return hasOverridingMetadataIdentifierXPath() ? getOverridingMetadataIdentifierXPath() : serviceLocator.getService(ISLookUpService.class)
				.getResourceProfileByQuery(xQuery);
	}

	private String getBaseUrl() throws ISLookUpException {
		String xQuery = "/*[.//RESOURCE_IDENTIFIER/@value='{datasourceId}']//INTERFACE[@id='{interfaceId}']//BASE_URL/string()";
		xQuery = xQuery.replace("{interfaceId}", datasourceInterface).replace("{datasourceId}", datasourceId);
		return serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xQuery);
	}

	private String getMetadataNamespace() {
		try {
			String xQuery =
					"let $x := /*[.//RESOURCE_IDENTIFIER/@value='{datasourceId}']//INTERFACE[@id='{interfaceId}']/ACCESS_PROTOCOL/@format/string() "
							+ "return /*[.//RESOURCE_TYPE/@value='MetadataFormatDSResourceType']//METADATAFORMAT[@Prefix=$x]/@NameSpace/string()";
			xQuery = xQuery.replace("{interfaceId}", datasourceInterface).replace("{datasourceId}", datasourceId);
			return serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xQuery);
		} catch (ISLookUpException e) {
			log.error("The interface is not OAI or the format is not found in the MetadataFormatDSResourceType, thus metadata format in the <about> section "
					+ "cannot managed here and it will be leaved empty (for the time being)");
			return "";
		}
	}

	private boolean hasOverridingMetadataIdentifierXPath() {
		return !getOverridingMetadataIdentifierXPath().isEmpty();
	}

	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public XSLTMappedResultSetFactory getXsltMappedResultSetFactory() {
		return xsltMappedResultSetFactory;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

	@Required
	public void setXsltMappedResultSetFactory(final XSLTMappedResultSetFactory xsltMappedResultSetFactory) {
		this.xsltMappedResultSetFactory = xsltMappedResultSetFactory;
	}

	public StringTemplate getMdBuilderTemplateXslt() {
		return mdBuilderTemplateXslt;
	}

	public void setMdBuilderTemplateXslt(final StringTemplate mdBuilderTemplateXslt) {
		this.mdBuilderTemplateXslt = mdBuilderTemplateXslt;
	}

	public boolean getInferred() {
		return inferred;
	}

	public void setInferred(final boolean inferred) {
		this.inferred = inferred;
	}

	public boolean getDeletedbyinference() {
		return deletedbyinference;
	}

	public void setDeletedbyinference(final boolean deletedbyinference) {
		this.deletedbyinference = deletedbyinference;
	}

	public String getInferenceprovenance() {
		return inferenceprovenance;
	}

	public void setInferenceprovenance(final String inferenceprovenance) {
		this.inferenceprovenance = inferenceprovenance;
	}

	public String getTrust() {
		return trust;
	}

	public void setTrust(final String trust) {
		this.trust = trust;
	}

	public String getProvenanceactionclassname() {
		return provenanceactionclassname;
	}

	public void setProvenanceactionclassname(final String provenanceactionclassname) {
		this.provenanceactionclassname = provenanceactionclassname;
	}

	public String getProvenanceactionclassid() {
		return provenanceactionclassid;
	}

	public void setProvenanceactionclassid(final String provenanceactionclassid) {
		this.provenanceactionclassid = provenanceactionclassid;
	}

	public String getOverridingMetadataIdentifierXPath() {
		return overridingMetadataIdentifierXPath;
	}

	public void setOverridingMetadataIdentifierXPath(final String overridingMetadataIdentifierXPath) {
		this.overridingMetadataIdentifierXPath = overridingMetadataIdentifierXPath;
	}

}
