<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
				xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa"
				xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions"
				xmlns:dnet="eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions" version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:template match="/">
		<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
				xmlns:dri="http://www.driver-repository.eu/namespace/dri"
				xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<xsl:variable name="rid" select="normalize-space(//repository/@rID)"/>
				<xsl:variable name="datasourceId" select="concat($namespacePrefix, '::', $rid)"/>
				<xsl:variable name="oUrl" select="normalize-space(//oUrl)"/>
				<xsl:variable name="oName" select="normalize-space(//oName)"/>
				<xsl:variable name="organizationId" select="translate(concat($namespacePrefix, '::', $oName), ' ', '_')"/>
				<xsl:variable name="repositoryType">
					<xsl:choose>
						<xsl:when test="normalize-space(//repositoryType) = 'Institutional'">
							<xsl:value-of select="string('pubsrepository::institutional')"/>
						</xsl:when>
						<xsl:when test="normalize-space(//repositoryType) = 'Disciplinary'">
							<xsl:value-of select="string('pubsrepository::thematic')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="string('pubsrepository::unknown')"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:variable name="contenttypes">
					<xsl:for-each select=".//contentType">
						<xsl:if test="position() &gt; 1">-</xsl:if>
						<xsl:value-of select="."/>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="languages">
					<xsl:for-each select=".//lName">
						<xsl:if test="position() &gt; 1">,</xsl:if>
						<xsl:value-of select="."/>
					</xsl:for-each>
				</xsl:variable>
				<ROWS>
					<ROW table="datasources">
						<FIELD name="id">
							<xsl:value-of select="$datasourceId"/>
						</FIELD>
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$datasourceId"/>
						</FIELD>
						<FIELD name="officialname">
							<xsl:value-of select="normalize-space(//rName)"/>
						</FIELD>
						<FIELD name="englishname">
							<xsl:value-of select="normalize-space(//rAcronym)"/>
						</FIELD>
						<FIELD name="od_contenttypes">
							<xsl:value-of select="normalize-space($contenttypes)"/>
						</FIELD>
						<FIELD name="od_languages">
							<xsl:value-of select="normalize-space($languages)"/>
						</FIELD>
						<FIELD name="od_numberofitems">
							<xsl:value-of select="normalize-space(//rNumOfItems)"/>
						</FIELD>
						<FIELD name="od_numberofitemsdate">
							<xsl:value-of select="normalize-space(//rDateHarvested)"/>
						</FIELD>
						<FIELD name="description">
							<xsl:value-of select="normalize-space(//rDescription)"/>
						</FIELD>
						<FIELD name="contactEmail">
							<xsl:value-of select="normalize-space(//pEmail)"/>
						</FIELD>
						<FIELD name="latitude" type="float">
							<xsl:value-of select="normalize-space(//paLatitude)"/>
						</FIELD>
						<FIELD name="longitude" type="float">
							<xsl:value-of select="normalize-space(//paLongitude)"/>
						</FIELD>
						<FIELD name="websiteurl">
							<xsl:value-of select="normalize-space(//rUrl)"/>
						</FIELD>
						<FIELD name="logourl"></FIELD>
						<FIELD name="namespaceprefix">
							<xsl:value-of select="dnet:generateNsPrefix('od', $rid)"/>
						</FIELD>
						<FIELD name="datasourceclass">
							<xsl:value-of select="$repositoryType"/>
						</FIELD>
						<FIELD name="datasourcescheme">dnet:datasource_typologies</FIELD>
						<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
						<FIELD name="typology">
							<xsl:value-of select="normalize-space(//rSoftWareName)"/>
						</FIELD>
						<FIELD name="optional1"></FIELD>
						<FIELD name="optional2"></FIELD>
						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
					</ROW>

					<xsl:for-each select=".//class">
						<xsl:variable name="subjectId" select="normalize-space(concat($parentDatasourceId, '::', ./clCode))"/>
						<xsl:variable name="subjectValue" select="normalize-space(./clTitle)"/>
						<ROW table="subjects">
							<FIELD name="id">
								<xsl:value-of select="$subjectId"/>
							</FIELD>
							<FIELD name="name">
								<xsl:value-of select="$subjectValue"/>
							</FIELD>
							<FIELD name="semanticclass">dnet:od_subjects</FIELD>
							<FIELD name="semanticscheme">dnet:subject_classification_typologies</FIELD>
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$subjectId"/>
							</FIELD>
						</ROW>
						<ROW table="datasource_subject">
							<FIELD name="datasource">
								<xsl:value-of select="$datasourceId"/>
							</FIELD>
							<FIELD name="subject">
								<xsl:value-of select="$subjectId"/>
							</FIELD>
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="concat($datasourceId, '@@', $subjectId)"/>
							</FIELD>
						</ROW>
					</xsl:for-each>

					<xsl:variable name="apiId" select="concat('api_________::', $datasourceId, '::0')"/>
					<ROW table="api">
						<FIELD name="id">
							<xsl:value-of select="$apiId"/>
						</FIELD>
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$apiId"/>
						</FIELD>
						<FIELD name="protocolclass">oai</FIELD>
						<FIELD name="datasource">
							<xsl:value-of select="$datasourceId"/>
						</FIELD>
						<FIELD name="contentdescriptionclass">metadata</FIELD>
						<FIELD name="typologyclass">
							<xsl:value-of select="$repositoryType"/>
						</FIELD>
					</ROW>

					<ROW table="apicollections">
						<FIELD name="api">
							<xsl:value-of select="$apiId"/>
						</FIELD>
						<FIELD name="param">baseUrl</FIELD>
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat($apiId, '@@baseUrl')"/>
						</FIELD>
						<xsl:choose>
							<xsl:when test="string-length(normalize-space(//rOaiBaseUrl)) &gt; 0">
								<FIELD name="original">
									<xsl:value-of select="normalize-space(//rOaiBaseUrl)"/>
								</FIELD>
							</xsl:when>
							<xsl:otherwise>
								<FIELD name="original">unknown</FIELD>
							</xsl:otherwise>
						</xsl:choose>
					</ROW>

					<ROW table="apicollections">
						<FIELD name="api">
							<xsl:value-of select="$apiId"/>
						</FIELD>
						<FIELD name="param">format</FIELD>
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat($apiId, '@@format')"/>
						</FIELD>
						<FIELD name="original">oai_dc</FIELD>
					</ROW>

					<ROW table="apicollections">
						<FIELD name="api">
							<xsl:value-of select="$apiId"/>
						</FIELD>
						<FIELD name="param">metadata_identifier_path</FIELD>
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat($apiId, '@@metadata_identifier_path')"/>
						</FIELD>
						<FIELD name="original">//*[local-name()='header']/*[local-name()='identifier']</FIELD>
						<FIELD name="accessparam" type="boolean">false</FIELD>
					</ROW>

					<ROW table="organizations">
						<FIELD name="id">
							<xsl:value-of select="$organizationId"/>
						</FIELD>
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$organizationId"/>
						</FIELD>
						<FIELD name="legalname">
							<xsl:value-of select="$oName"/>
						</FIELD>
						<FIELD name="legalshortname">
							<xsl:value-of select="normalize-space(//oAcronym)"/>
						</FIELD>
						<FIELD name="websiteurl">
							<xsl:choose>
								<xsl:when test="starts-with(normalize-space(//oUrl), 'http')">
									<xsl:value-of select="normalize-space(//oUrl)" />
								</xsl:when>
								<xsl:when test="string-length(normalize-space(//oUrl)) &gt; 0">
									<xsl:value-of select="concat('http://', normalize-space(//oUrl))" />
								</xsl:when>
							</xsl:choose>
						</FIELD>
						<FIELD name="countryClass">
							<xsl:choose>
								<xsl:when test="normalize-space(//cIsoCode) = 'GB'">UK</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="normalize-space(//cIsoCode)"></xsl:value-of>
								</xsl:otherwise>
							</xsl:choose>
						</FIELD>
						<FIELD name="countryScheme">dnet:countries</FIELD>
						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
						<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
						<FIELD name="trust" type="float">0.8</FIELD>
					</ROW>

					<ROW table="datasource_organization">
						<FIELD name="datasource">
							<xsl:value-of select="$datasourceId"/>
						</FIELD>
						<FIELD name="organization">
							<xsl:value-of select="$organizationId"/>
						</FIELD>
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat($datasourceId,'@@',$organizationId)"/>
						</FIELD>
					</ROW>

				</ROWS>
			</metadata>
		</record>
	</xsl:template>

</xsl:stylesheet>
