package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import java.io.StringReader;
import java.util.Map;
import java.util.Map.Entry;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class PrepareContextDbEntriesJobNode extends SimpleJobNode {

	private String contextObj;
	private String eprParam;

	private static final Log log = LogFactory.getLog(PrepareContextDbEntriesJobNode.class);

	@Resource
	private IterableResultSetFactory iterableResultSetFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final ContextDesc desc = (ContextDesc) token.getEnv().getTransientAttribute(contextObj);

		final Iterable<String> iter = Iterables.transform(desc.getDbEntries().entrySet(), ContextUtils.getContextRowTransformer());
		final W3CEndpointReference epr = iterableResultSetFactory.createIterableResultSet(iter);

		token.getEnv().setAttribute(eprParam, epr.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getContextObj() {
		return contextObj;
	}

	public void setContextObj(final String contextObj) {
		this.contextObj = contextObj;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

}
