package eu.dnetlib.msro.openaireplus.workflows.nodes.repobye;

import javax.annotation.Resource;

import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.repobye.DeleteMetaWfJobNode;

public class DeleteOpenaireMetaWfJobNode extends DeleteMetaWfJobNode {

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected void updateIfaceActivationStatus(final String dsId, final String ifaceId, final boolean active) throws Exception {

		final String openaireDsId = serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(
				"/*[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']//FIELD/value[../key='OpenAireDataSourceId']/text()");

		if (openaireDsId.equals("openaire____::bootstrap")) {
			super.updateIfaceActivationStatus(dsId, ifaceId, active);
		} else {
			serviceLocator.getService(DatasourceManagerService.class).updateActivationStatus(openaireDsId, ifaceId, active);
		}
	}
}
