<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="COLLECT"/>
	</ARCS>
</NODE>

<NODE name="COLLECT" type="QueryDb">
	<DESCRIPTION>Collect claims from DB</DESCRIPTION>
	<PARAMETERS>
		<PARAM name="dbProperty" type="string" managedBy="system" required="true">dnet.openaire.db.name</PARAM>
		<PARAM name="sql" type="string" managedBy="user" required="true"
                function="listFiles('/eu/dnetlib/msro/openaireplus/workflows/db','sql')">/eu/dnetlib/msro/openaireplus/workflows/db/queryClaimsDmf.sql</PARAM>
		<PARAM name="outputEprParam" type="string" managedBy="system" required="true">collected_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="DECAPSULE" />
	</ARCS>
</NODE>	

<NODE name="DECAPSULE" type="DecapsuleClaims">
	<DESCRIPTION>Prepare mdstore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">collected_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">store_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="STORE" />
	</ARCS>
</NODE>

<NODE name="STORE" type="StoreMDStoreRecords">
	<DESCRIPTION>Store mdtore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="user">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">store_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_INFO"/>
	</ARCS>
</NODE>

<NODE name="UPDATE_INFO" type="MDStoreToApiExtraField">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_collection_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_collection_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">last_collection_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>

 