/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import java.text.DecimalFormat;

public abstract class AbstractBuilderModule {
    private final String predefinedTrust;
    private float confidenceToTrustLevelNormalizationFactor = 0.9f;
    protected final String inferenceProvenance;
    protected final ActionFactory actionFactory = new ActionFactory();
    private final DecimalFormat decimalFormat = new DecimalFormat("#.####");

    public AbstractBuilderModule(String predefinedTrust, AlgorithmName algorithmName) {
        this.predefinedTrust = predefinedTrust;
        this.inferenceProvenance = AbstractBuilderModule.buildInferenceProvenance(algorithmName);
    }

    private static final String buildInferenceProvenance(AlgorithmName algorithmName) {
        return "iis::" + algorithmName.toString();
    }

    protected OafProtos.Oaf buildOaf(OafProtos.OafEntity oafEntity) {
        return this.buildOaf(oafEntity, null);
    }

    protected OafProtos.Oaf buildOaf(OafProtos.OafEntity oafEntity, FieldTypeProtos.DataInfo dataInfo) {
        OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
        oafBuilder.setKind(KindProtos.Kind.entity);
        oafBuilder.setEntity(oafEntity);
        if (dataInfo != null) {
            oafBuilder.setDataInfo(dataInfo);
        }
        oafBuilder.setTimestamp(System.currentTimeMillis());
        return oafBuilder.build();
    }

    protected FieldTypeProtos.DataInfo buildInference() {
        return this.buildInference(this.predefinedTrust);
    }

    protected FieldTypeProtos.DataInfo buildInference(float confidenceLevel) {
        return this.buildInference(this.decimalFormat.format(confidenceLevel * this.confidenceToTrustLevelNormalizationFactor));
    }

    private FieldTypeProtos.DataInfo buildInference(String trustLevel) {
        FieldTypeProtos.DataInfo.Builder builder = FieldTypeProtos.DataInfo.newBuilder();
        builder.setInferred(true);
        builder.setTrust(trustLevel);
        FieldTypeProtos.Qualifier.Builder provenanceBuilder = FieldTypeProtos.Qualifier.newBuilder();
        provenanceBuilder.setClassid("iis");
        provenanceBuilder.setClassname("iis");
        provenanceBuilder.setSchemeid("dnet:provenanceActions");
        provenanceBuilder.setSchemename("dnet:provenanceActions");
        builder.setProvenanceaction(provenanceBuilder.build());
        builder.setInferenceprovenance(this.inferenceProvenance);
        return builder.build();
    }

    protected RelMetadataProtos.RelMetadata buildRelMetadata(String schemaId, String classId) {
        RelMetadataProtos.RelMetadata.Builder relBuilder = RelMetadataProtos.RelMetadata.newBuilder();
        FieldTypeProtos.Qualifier.Builder qBuilder = FieldTypeProtos.Qualifier.newBuilder();
        qBuilder.setSchemeid(schemaId);
        qBuilder.setSchemename(schemaId);
        qBuilder.setClassid(classId);
        qBuilder.setClassname(classId);
        relBuilder.setSemantics(qBuilder.build());
        return relBuilder.build();
    }

    protected OafProtos.Oaf invertBidirectionalRelationAndBuild(OafProtos.Oaf.Builder existingBuilder) {
        if (existingBuilder.getRel() != null) {
            if (existingBuilder.getRel().getSource() != null && existingBuilder.getRel().getTarget() != null) {
                OafProtos.Oaf.Builder builder = existingBuilder.clone();
                OafProtos.OafRel.Builder relBuilder = builder.getRelBuilder();
                String source = relBuilder.getSource();
                String target = relBuilder.getTarget();
                relBuilder.setSource(target);
                relBuilder.setTarget(source);
                builder.setRel(relBuilder.build());
                builder.setTimestamp(System.currentTimeMillis());
                return builder.build();
            }
            throw new RuntimeException("invalid state: either source or target relation was missing!");
        }
        throw new RuntimeException("invalid state: no relation object found!");
    }

    public String getPredefinedTrust() {
        return this.predefinedTrust;
    }

    public void setConfidenceToTrustLevelNormalizationFactor(float confidenceToTrustLevelNormalizationFactor) {
        this.confidenceToTrustLevelNormalizationFactor = confidenceToTrustLevelNormalizationFactor;
    }

    public float getConfidenceToTrustLevelNormalizationFactor() {
        return this.confidenceToTrustLevelNormalizationFactor;
    }
}

