/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.OrganizationProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultOrganizationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import eu.dnetlib.iis.common.hbase.HBaseConstants;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.export.schemas.DocumentMetadata;
import eu.dnetlib.iis.metadataextraction.schemas.Affiliation;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class DocumentAffiliationsActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentMetadata> {
    private static final String COUNTRIES_VOCABULARY_LOCATION = "countries.vocabulary.location";
    private static final AlgorithmName algorithmName = AlgorithmName.document_affiliations;
    private static final String IIS_NS_PREFIX = "iisinference";
    private static final Logger log = Logger.getLogger(DocumentAffiliationsActionBuilderModuleFactory.class);

    @Override
    public ActionBuilderModule<DocumentMetadata> instantiate(String predefinedTrust, Configuration config) {
        String countriesVocabularyLocation = config.get(COUNTRIES_VOCABULARY_LOCATION);
        Properties countriesVocabularyProps = null;
        if (countriesVocabularyLocation != null) {
            try {
                FileSystem fs = FileSystem.get((Configuration)config);
                countriesVocabularyProps = new Properties();
                countriesVocabularyProps.load((InputStream)fs.open(new Path(countriesVocabularyLocation)));
            }
            catch (IOException e) {
                throw new RuntimeException("exception occurred while loading vocabularies", e);
            }
        }
        return new DocumentMetadataActionBuilderModule(predefinedTrust, countriesVocabularyProps);
    }

    class DocumentMetadataActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentMetadata> {
        private final String entityTargetColumn;
        private final Properties countriesVocabulary;

        public DocumentMetadataActionBuilderModule(String predefinedTrust, Properties countriesVocabulary) {
            super(predefinedTrust, algorithmName);
            this.countriesVocabulary = countriesVocabulary;
            try {
                this.entityTargetColumn = new String(HBaseConstants.QUALIFIER_BODY, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<AtomicAction> build(DocumentMetadata object, Agent agent, String actionSetId) {
            if (this.countriesVocabulary == null) {
                throw new RuntimeException("countries vocabulary not provided, missing property value: countries.vocabulary.location");
            }
            System.out.println("got affiliations for id: " + object.getId().toString() + ": " + this.buildAffiliationsString(object.getAffiliations()));
            return null;
        }

        protected List<AtomicAction> buildAffiliationActions(DocumentMetadata object, Agent agent, String actionSetId) {
            String docId = object.getId().toString();
            if (object.getAffiliations() != null && !object.getAffiliations().isEmpty()) {
                ArrayList<AtomicAction> actions = new ArrayList<AtomicAction>();
                for (Affiliation currentAffiliation : object.getAffiliations()) {
                    String organizationName;
                    String string = organizationName = currentAffiliation.getOrganization() != null ? currentAffiliation.getOrganization().toString() : null;
                    if (organizationName == null || organizationName.isEmpty()) {
                        log.warn((Object)("skipping organization entity and relations export: empty organization name for document: " + object.getId() + ", raw affiliation text: " + currentAffiliation.getRawText()));
                        continue;
                    }
                    String currentOrganizationId = this.buildOrganizationIndetifier(currentAffiliation.getRawText().toString());
                    OafProtos.Oaf organizationEntity = this.buildOrganizationOaf(currentOrganizationId, organizationName, currentAffiliation.getCountryCode() != null ? currentAffiliation.getCountryCode().toString() : null);
                    actions.add(this.actionFactory.createAtomicAction(actionSetId, agent, currentOrganizationId, OafDecoder.decode((OafProtos.Oaf)organizationEntity).getCFQ(), this.entityTargetColumn, organizationEntity.toByteArray()));
                    OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
                    oafBuilder.setKind(KindProtos.Kind.relation);
                    OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
                    relBuilder.setChild(false);
                    relBuilder.setRelType(RelTypeProtos.RelType.resultOrganization);
                    relBuilder.setSource(docId);
                    relBuilder.setTarget(currentOrganizationId);
                    ResultOrganizationProtos.ResultOrganization.Builder resOrganizationBuilder = ResultOrganizationProtos.ResultOrganization.newBuilder();
                    relBuilder.setResultOrganization(resOrganizationBuilder.build());
                    oafBuilder.setRel(relBuilder.build());
                    oafBuilder.setDataInfo(this.buildInference());
                    oafBuilder.setTimestamp(System.currentTimeMillis());
                    OafProtos.Oaf oaf = oafBuilder.build();
                    OafProtos.Oaf oafInverted = this.invertBidirectionalRelationAndBuild(oafBuilder);
                    actions.add(this.actionFactory.createAtomicAction(actionSetId, agent, docId, OafDecoder.decode((OafProtos.Oaf)oaf).getCFQ(), currentOrganizationId, oaf.toByteArray()));
                    actions.add(this.actionFactory.createAtomicAction(actionSetId, agent, currentOrganizationId, OafDecoder.decode((OafProtos.Oaf)oafInverted).getCFQ(), docId, oafInverted.toByteArray()));
                }
                return actions;
            }
            return null;
        }

        String buildAffiliationsString(List<Affiliation> affiliations) {
            if (affiliations != null) {
                StringBuilder strBuilder = new StringBuilder();
                for (Affiliation affiliation : affiliations) {
                    strBuilder.append("{");
                    strBuilder.append("\"organization\": ");
                    strBuilder.append('\"');
                    strBuilder.append(affiliation.getOrganization());
                    strBuilder.append('\"');
                    strBuilder.append(',');
                    strBuilder.append("\"countryName\": ");
                    strBuilder.append('\"');
                    strBuilder.append(affiliation.getCountryName());
                    strBuilder.append('\"');
                    strBuilder.append(',');
                    strBuilder.append("\"countryCode\": ");
                    strBuilder.append('\"');
                    strBuilder.append(affiliation.getCountryCode());
                    strBuilder.append('\"');
                    strBuilder.append(',');
                    strBuilder.append("\"rawText\": ");
                    strBuilder.append('\"');
                    strBuilder.append(affiliation.getRawText());
                    strBuilder.append('\"');
                    strBuilder.append("}");
                }
                return strBuilder.toString();
            }
            return "null";
        }

        String buildOrganizationIndetifier(String organizationText) {
            return AbstractDNetOafXsltFunctions.oafId((String)TypeProtos.Type.organization.name(), (String)DocumentAffiliationsActionBuilderModuleFactory.IIS_NS_PREFIX, (String)organizationText);
        }

        OafProtos.Oaf buildOrganizationOaf(String id, String name, String countryCode) {
            OafProtos.OafEntity.Builder orgEntityBuilder = OafProtos.OafEntity.newBuilder();
            OrganizationProtos.Organization.Builder orgBuilder = OrganizationProtos.Organization.newBuilder();
            OrganizationProtos.Organization.Metadata.Builder orgMetaBuilder = OrganizationProtos.Organization.Metadata.newBuilder();
            FieldTypeProtos.StringField.Builder nameBuilder = FieldTypeProtos.StringField.newBuilder();
            nameBuilder.setValue(name.toString());
            orgMetaBuilder.setLegalname(nameBuilder.build());
            if (countryCode != null) {
                FieldTypeProtos.Qualifier.Builder countryBuilder = FieldTypeProtos.Qualifier.newBuilder();
                countryBuilder.setSchemeid("dnet:countries");
                countryBuilder.setSchemename("dnet:countries");
                countryBuilder.setClassid(countryCode);
                String countryName = this.countriesVocabulary.getProperty(countryCode);
                if (countryName != null) {
                    countryBuilder.setClassname(countryName);
                } else {
                    log.warn((Object)("got null country name from vocabulary for country code: " + countryCode));
                }
                orgMetaBuilder.setCountry(countryBuilder.build());
            }
            orgBuilder.setMetadata(orgMetaBuilder.build());
            orgEntityBuilder.setOrganization(orgBuilder.build());
            orgEntityBuilder.setId(id);
            orgEntityBuilder.setType(TypeProtos.Type.organization);
            OafProtos.Oaf organizationOaf = this.buildOaf(orgEntityBuilder.build(), this.buildInference());
            return organizationOaf;
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return algorithmName;
        }
    }
}

