/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.websiteusage.schemas.DocumentsWithWebsiteUsageSimilarities;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class DocumentsWithWebsiteUsageSimilaritiesActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentsWithWebsiteUsageSimilarities> {
    private static final AlgorithmName algorithmName = AlgorithmName.document_similarities_websiteusage;

    @Override
    public ActionBuilderModule<DocumentsWithWebsiteUsageSimilarities> instantiate(String predefinedTrust, Configuration config) {
        return new DocumentsWithWebsiteUsageSimilaritiesActionBuilder(predefinedTrust);
    }

    class DocumentsWithWebsiteUsageSimilaritiesActionBuilder
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentsWithWebsiteUsageSimilarities> {
        private final float defaultSimilarityLevel = 0.0f;

        public DocumentsWithWebsiteUsageSimilaritiesActionBuilder(String predefinedTrust) {
            super(predefinedTrust, algorithmName);
            this.defaultSimilarityLevel = 0.0f;
        }

        @Override
        public List<AtomicAction> build(DocumentsWithWebsiteUsageSimilarities object, Agent agent, String actionSetId) {
            String currentSimDocId = object.getOtherDocumentId().toString();
            String docId = object.getDocumentId().toString();
            OafProtos.Oaf similarityRel = this.buildSimilarityRel(docId, currentSimDocId, object.getCovisitedSimilarity() != null ? object.getCovisitedSimilarity().floatValue() : 0.0f);
            OafProtos.Oaf reverseSimilarityRel = this.buildSimilarityRel(currentSimDocId, docId, object.getCovisitedSimilarity() != null ? object.getCovisitedSimilarity().floatValue() : 0.0f);
            return Arrays.asList(this.actionFactory.createAtomicAction(actionSetId, agent, docId, OafDecoder.decode((OafProtos.Oaf)similarityRel).getCFQ(), currentSimDocId, similarityRel.toByteArray()), this.actionFactory.createAtomicAction(actionSetId, agent, currentSimDocId, OafDecoder.decode((OafProtos.Oaf)reverseSimilarityRel).getCFQ(), docId, reverseSimilarityRel.toByteArray()));
        }

        private OafProtos.Oaf buildSimilarityRel(String source, String target, float score) {
            OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
            relBuilder.setSource(source);
            relBuilder.setTarget(target);
            relBuilder.setChild(false);
            relBuilder.setRelType(RelTypeProtos.RelType.resultResult);
            relBuilder.setSubRelType(RelTypeProtos.SubRelType.similarity);
            ResultResultProtos.ResultResult.Builder resResBuilder = ResultResultProtos.ResultResult.newBuilder();
            resResBuilder.setSimilarity(ResultResultProtos.ResultResult.Similarity.newBuilder().setType(ResultResultProtos.ResultResult.Similarity.Type.WEBUSAGE).setSimilarity(score).build());
            relBuilder.setResultResult(resResBuilder.build());
            OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
            oafBuilder.setKind(KindProtos.Kind.relation);
            oafBuilder.setRel(relBuilder.build());
            oafBuilder.setDataInfo(this.buildInference());
            oafBuilder.setTimestamp(System.currentTimeMillis());
            return oafBuilder.build();
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return algorithmName;
        }
    }
}

