/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.export.actionmanager.module.toxml.CommonCoreStatisticsXmlConverter;
import eu.dnetlib.iis.statistics.schemas.ProjectToProjectStatistics;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class ProjectToProjectStatisticsActionBuilderModuleFactory
implements ActionBuilderFactory<ProjectToProjectStatistics> {
    private static final String EXTRA_INFO_NAME = "project statistics";
    private static final String EXTRA_INFO_TYPOLOGY = "statistics";
    private static final AlgorithmName algorithmName = AlgorithmName.project_statistics;

    @Override
    public ActionBuilderModule<ProjectToProjectStatistics> instantiate(String predefinedTrust, Configuration config) {
        return new ProjectToProjectStatisticsActionBuilderModule(predefinedTrust);
    }

    class ProjectToProjectStatisticsActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<ProjectToProjectStatistics> {
        CommonCoreStatisticsXmlConverter converter;

        public ProjectToProjectStatisticsActionBuilderModule(String predefinedTrust) {
            super(predefinedTrust, algorithmName);
            this.converter = new CommonCoreStatisticsXmlConverter();
        }

        @Override
        public List<AtomicAction> build(ProjectToProjectStatistics object, Agent agent, String actionSetId) {
            OafProtos.Oaf oafObject = this.buildOAF(object);
            if (oafObject != null) {
                return this.actionFactory.createUpdateActions(actionSetId, agent, object.getProjectId().toString(), TypeProtos.Type.project, oafObject.toByteArray());
            }
            return null;
        }

        protected OafProtos.Oaf buildOAF(ProjectToProjectStatistics source) {
            if (source.getStatistics() != null) {
                OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                if (source.getProjectId() != null) {
                    entityBuilder.setId(source.getProjectId().toString());
                }
                FieldTypeProtos.ExtraInfo.Builder extraInfoBuilder = FieldTypeProtos.ExtraInfo.newBuilder();
                extraInfoBuilder.setValue(this.converter.serialize(source.getStatistics()));
                extraInfoBuilder.setName(ProjectToProjectStatisticsActionBuilderModuleFactory.EXTRA_INFO_NAME);
                extraInfoBuilder.setTypology(ProjectToProjectStatisticsActionBuilderModuleFactory.EXTRA_INFO_TYPOLOGY);
                extraInfoBuilder.setProvenance(this.inferenceProvenance);
                extraInfoBuilder.setTrust(this.getPredefinedTrust());
                entityBuilder.addExtraInfo(extraInfoBuilder.build());
                entityBuilder.setType(TypeProtos.Type.project);
                return this.buildOaf(entityBuilder.build());
            }
            return null;
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return algorithmName;
        }
    }
}

