/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.export.actionmanager.module.toxml.CommonBasicCitationStatisticsXmlConverter;
import eu.dnetlib.iis.statistics.schemas.DocumentToDocumentStatistics;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class DocumentToDocumentStatisticsActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentToDocumentStatistics> {
    private static final String EXTRA_INFO_NAME = "result statistics";
    private static final String EXTRA_INFO_TYPOLOGY = "statistics";
    private static final AlgorithmName algorithmName = AlgorithmName.document_statistics;

    @Override
    public ActionBuilderModule<DocumentToDocumentStatistics> instantiate(String predefinedTrust, Configuration config) {
        return new DocumentToDocumentStatisticsActionBuilderModule(predefinedTrust);
    }

    class DocumentToDocumentStatisticsActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentToDocumentStatistics> {
        CommonBasicCitationStatisticsXmlConverter converter;

        public DocumentToDocumentStatisticsActionBuilderModule(String predefinedTrust) {
            super(predefinedTrust, algorithmName);
            this.converter = new CommonBasicCitationStatisticsXmlConverter();
        }

        @Override
        public List<AtomicAction> build(DocumentToDocumentStatistics object, Agent agent, String actionSetId) {
            OafProtos.Oaf oaf = this.buildOAFStatistics(object);
            if (oaf != null) {
                return this.actionFactory.createUpdateActions(actionSetId, agent, object.getDocumentId().toString(), TypeProtos.Type.result, oaf.toByteArray());
            }
            return Collections.emptyList();
        }

        protected OafProtos.Oaf buildOAFStatistics(DocumentToDocumentStatistics source) {
            if (source.getStatistics() != null) {
                OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                if (source.getDocumentId() != null) {
                    entityBuilder.setId(source.getDocumentId().toString());
                }
                FieldTypeProtos.ExtraInfo.Builder extraInfoBuilder = FieldTypeProtos.ExtraInfo.newBuilder();
                extraInfoBuilder.setValue(this.converter.serialize(source.getStatistics()));
                extraInfoBuilder.setName(DocumentToDocumentStatisticsActionBuilderModuleFactory.EXTRA_INFO_NAME);
                extraInfoBuilder.setTypology(DocumentToDocumentStatisticsActionBuilderModuleFactory.EXTRA_INFO_TYPOLOGY);
                extraInfoBuilder.setProvenance(this.inferenceProvenance);
                extraInfoBuilder.setTrust(this.getPredefinedTrust());
                entityBuilder.addExtraInfo(extraInfoBuilder.build());
                entityBuilder.setType(TypeProtos.Type.result);
                return this.buildOaf(entityBuilder.build());
            }
            return null;
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return algorithmName;
        }
    }
}

