/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.entity.document;

import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.tools.JaxwsServiceResolverImpl;
import eu.dnetlib.iis.common.hbase.HBaseConstants;
import eu.dnetlib.iis.core.java.HadoopContext;
import eu.dnetlib.iis.core.java.PortBindings;
import eu.dnetlib.iis.core.java.Process;
import eu.dnetlib.iis.core.java.ProcessUtils;
import eu.dnetlib.iis.core.java.io.CloseableIterator;
import eu.dnetlib.iis.core.java.io.DataStore;
import eu.dnetlib.iis.core.java.io.FileSystemPath;
import eu.dnetlib.iis.core.java.porttype.AvroPortType;
import eu.dnetlib.iis.core.java.porttype.PortType;
import eu.dnetlib.iis.export.actionmanager.api.HBaseActionManagerServiceFacade;
import eu.dnetlib.iis.export.actionmanager.cfg.StaticConfigurationProvider;
import eu.dnetlib.iis.export.auxiliary.schemas.Identifier;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class DocumentExporterProcess
implements Process {
    private final Logger log = Logger.getLogger(this.getClass());
    private static final String inputPort = "input";
    private static final String documentIdPrefix;

    public Map<String, PortType> getInputPorts() {
        return DocumentExporterProcess.createInputPorts();
    }

    private static HashMap<String, PortType> createInputPorts() {
        HashMap<String, PortType> inputPorts = new HashMap<String, PortType>();
        inputPorts.put(inputPort, (PortType)new AvroPortType(Identifier.SCHEMA$));
        return inputPorts;
    }

    public Map<String, PortType> getOutputPorts() {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(PortBindings portBindings, HadoopContext context, Map<String, String> parameters) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        String mdStoreLocation = ProcessUtils.getParameterValue((String)"import.document.mdstore.service.location", (Configuration)context.getConfiguration(), parameters);
        String mdStoreId = ProcessUtils.getParameterValue((String)"import.document.mdstore.id", (Configuration)context.getConfiguration(), parameters);
        String actionSetId = ProcessUtils.getParameterValue((String)"export.action.setid", (Configuration)context.getConfiguration(), parameters);
        if (mdStoreLocation == null || "$UNDEFINED$".equals(mdStoreLocation)) {
            throw new InvalidParameterException("unable to export document entities to action manager, unknown MDStore service location. Required parameter 'import.document.mdstore.service.location' is missing!");
        }
        if (mdStoreId == null || "$UNDEFINED$".equals(mdStoreId)) {
            throw new InvalidParameterException("unable to export document entities to action manager, unknown MDStore identifier. Required parameter 'import.document.mdstore.id' is missing!");
        }
        if (actionSetId == null || "$UNDEFINED$".equals(actionSetId)) {
            throw new RuntimeException("unable to export document entities to action manager, no 'export.action.setid' required parameter provided!");
        }
        W3CEndpointReferenceBuilder eprBuilder = new W3CEndpointReferenceBuilder();
        eprBuilder.address(mdStoreLocation);
        eprBuilder.build();
        MDStoreService mdStore = (MDStoreService)new JaxwsServiceResolverImpl().getService(MDStoreService.class, eprBuilder.build());
        CloseableIterator idsIt = DataStore.getReader((FileSystemPath)new FileSystemPath(fs, (Path)portBindings.getInput().get(inputPort)));
        HashMap<String, ClassPathResource> xslts = new HashMap<String, ClassPathResource>();
        String documentXSLT = "dmf2actions";
        xslts.put(documentXSLT, new ClassPathResource("eu/dnetlib/actionmanager/xslt/dmf2insertActions.xslt"));
        ActionFactory actionFactory = new ActionFactory();
        actionFactory.setXslts(xslts);
        HBaseActionManagerServiceFacade actionManager = new HBaseActionManagerServiceFacade(context.getConfiguration(), parameters);
        StaticConfigurationProvider configProvider = new StaticConfigurationProvider(StaticConfigurationProvider.AGENT_DEFAULT, StaticConfigurationProvider.PROVENANCE_DEFAULT, "0.9", "webcrawl____");
        HashSet<String> exportedDocumentIds = new HashSet<String>();
        try {
            long timeSplit = System.currentTimeMillis();
            int counter = 0;
            while (idsIt.hasNext()) {
                String documentId = ((Identifier)idsIt.next()).getId().toString();
                if (exportedDocumentIds.contains(documentId)) continue;
                try {
                    String mdStoreRecord = mdStore.deliverRecord(mdStoreId, DocumentExporterProcess.convertToMDStoreId(documentId));
                    if (mdStoreRecord != null) {
                        actionManager.storeAction(actionFactory.generateInfoPackageAction(documentXSLT, actionSetId, configProvider.provideAgent(), Operation.INSERT, mdStoreRecord, configProvider.provideProvenance(), configProvider.provideNamespacePrefix(), configProvider.provideActionTrust()));
                        if (++counter % 10000 == 0) {
                            this.log.warn((Object)("exported " + counter + " documents in " + (System.currentTimeMillis() - timeSplit) / 1000L + " secs"));
                            timeSplit = System.currentTimeMillis();
                        }
                    }
                    exportedDocumentIds.add(documentId);
                }
                catch (DocumentNotFoundException e) {
                    this.log.error((Object)("mdrecord: " + DocumentExporterProcess.convertToMDStoreId(documentId) + " wasn't found in mdstore: " + mdStoreId), (Throwable)e);
                }
                catch (Exception e) {
                    this.log.error((Object)("got exception when trying to retrieve MDStore record for mdstore id " + mdStoreId + ", and document id: " + DocumentExporterProcess.convertToMDStoreId(documentId)), (Throwable)e);
                    throw e;
                }
            }
            this.log.warn((Object)("exported " + counter + " documents in total"));
        }
        finally {
            idsIt.close();
            actionManager.close();
        }
    }

    private static final String convertToMDStoreId(String id) {
        if (id != null) {
            if (id.startsWith(documentIdPrefix)) {
                return id.substring(documentIdPrefix.length());
            }
            return id;
        }
        return null;
    }

    static {
        try {
            documentIdPrefix = new String(HBaseConstants.ROW_PREFIX_RESULT, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

