/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.export.schemas.DocumentToConceptIds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public abstract class AbstractDocumentToConceptsActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentToConceptIds> {
    private final AlgorithmName algorithmName;

    public AbstractDocumentToConceptsActionBuilderModuleFactory(AlgorithmName algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Override
    public ActionBuilderModule<DocumentToConceptIds> instantiate(String predefinedTrust, Configuration config) {
        return new DocumentToConceptsActionBuilderModule(predefinedTrust);
    }

    class DocumentToConceptsActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentToConceptIds> {
        public DocumentToConceptsActionBuilderModule(String predefinedTrust) {
            super(predefinedTrust, AbstractDocumentToConceptsActionBuilderModuleFactory.this.algorithmName);
        }

        @Override
        public List<AtomicAction> build(DocumentToConceptIds object, Agent agent, String actionSetId) {
            OafProtos.Oaf oaf = this.buildOAFResearchInitiativeConcepts(object);
            if (oaf != null) {
                return this.actionFactory.createUpdateActions(actionSetId, agent, object.getDocumentId().toString(), TypeProtos.Type.result, oaf.toByteArray());
            }
            return Collections.emptyList();
        }

        protected OafProtos.Oaf buildOAFResearchInitiativeConcepts(DocumentToConceptIds source) {
            if (source.getConceptIds() != null && source.getConceptIds().size() > 0) {
                ResultProtos.Result.Metadata.Builder metaBuilder = ResultProtos.Result.Metadata.newBuilder();
                ArrayList<ResultProtos.Result.Context> contexts = new ArrayList<ResultProtos.Result.Context>(source.getConceptIds().size());
                for (CharSequence riConceptId : source.getConceptIds()) {
                    ResultProtos.Result.Context.Builder contextBuilder = ResultProtos.Result.Context.newBuilder();
                    contextBuilder.setId(riConceptId.toString());
                    contextBuilder.setDataInfo(this.buildInference());
                    contexts.add(contextBuilder.build());
                }
                metaBuilder.addAllContext(contexts);
                ResultProtos.Result.Builder resultBuilder = ResultProtos.Result.newBuilder();
                resultBuilder.setMetadata(metaBuilder.build());
                OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                if (source.getDocumentId() != null) {
                    entityBuilder.setId(source.getDocumentId().toString());
                }
                entityBuilder.setType(TypeProtos.Type.result);
                entityBuilder.setResult(resultBuilder.build());
                return this.buildOaf(entityBuilder.build());
            }
            return null;
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return AbstractDocumentToConceptsActionBuilderModuleFactory.this.algorithmName;
        }
    }
}

