/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.referenceextraction.project.schemas.DocumentToProject;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class DocumentToProjectActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentToProject> {
    public static final String REL_CLASS_ISPRODUCEDBY = ResultProjectProtos.ResultProject.Outcome.RelName.isProducedBy.toString();
    public static final String REL_CLASS_PRODUCES = ResultProjectProtos.ResultProject.Outcome.RelName.produces.toString();
    private static final AlgorithmName algorithmName = AlgorithmName.document_referencedProjects;

    @Override
    public ActionBuilderModule<DocumentToProject> instantiate(String predefinedTrust, Configuration config) {
        return new DocumentToProjectActionBuilderModule(predefinedTrust);
    }

    class DocumentToProjectActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentToProject> {
        public DocumentToProjectActionBuilderModule(String predefinedTrust) {
            super(predefinedTrust, algorithmName);
        }

        @Override
        public List<AtomicAction> build(DocumentToProject object, Agent agent, String actionSetId) {
            String docId = object.getDocumentId().toString();
            String currentProjectIdStr = object.getProjectId().toString();
            OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
            oafBuilder.setKind(KindProtos.Kind.relation);
            OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
            relBuilder.setChild(false);
            relBuilder.setRelType(RelTypeProtos.RelType.resultProject);
            relBuilder.setSubRelType(RelTypeProtos.SubRelType.outcome);
            relBuilder.setRelClass(REL_CLASS_ISPRODUCEDBY);
            relBuilder.setSource(docId);
            relBuilder.setTarget(currentProjectIdStr);
            ResultProjectProtos.ResultProject.Builder resProjBuilder = ResultProjectProtos.ResultProject.newBuilder();
            ResultProjectProtos.ResultProject.Outcome.Builder outcomeBuilder = ResultProjectProtos.ResultProject.Outcome.newBuilder();
            outcomeBuilder.setRelMetadata(this.buildRelMetadata("dnet:result_project_relations", REL_CLASS_ISPRODUCEDBY));
            resProjBuilder.setOutcome(outcomeBuilder.build());
            relBuilder.setResultProject(resProjBuilder.build());
            oafBuilder.setRel(relBuilder.build());
            oafBuilder.setDataInfo(object.getConfidenceLevel() != null ? this.buildInference(object.getConfidenceLevel().floatValue()) : this.buildInference());
            oafBuilder.setTimestamp(System.currentTimeMillis());
            OafProtos.Oaf oaf = oafBuilder.build();
            OafProtos.Oaf oafInv = this.invertRelationAndBuild(oafBuilder);
            return Arrays.asList(this.actionFactory.createAtomicAction(actionSetId, agent, docId, OafDecoder.decode((OafProtos.Oaf)oaf).getCFQ(), currentProjectIdStr, oaf.toByteArray()), this.actionFactory.createAtomicAction(actionSetId, agent, currentProjectIdStr, OafDecoder.decode((OafProtos.Oaf)oafInv).getCFQ(), docId, oafInv.toByteArray()));
        }

        private OafProtos.Oaf invertRelationAndBuild(OafProtos.Oaf.Builder existingBuilder) {
            if (existingBuilder.getRel() != null) {
                if (existingBuilder.getRel().getSource() != null && existingBuilder.getRel().getTarget() != null) {
                    OafProtos.Oaf.Builder builder = existingBuilder.clone();
                    OafProtos.OafRel.Builder relBuilder = builder.getRelBuilder();
                    String source = relBuilder.getSource();
                    String target = relBuilder.getTarget();
                    relBuilder.setSource(target);
                    relBuilder.setTarget(source);
                    relBuilder.setRelClass(REL_CLASS_PRODUCES);
                    if (relBuilder.getResultProjectBuilder() != null && relBuilder.getResultProjectBuilder().getOutcomeBuilder() != null && relBuilder.getResultProjectBuilder().getOutcomeBuilder().getRelMetadataBuilder() != null && relBuilder.getResultProjectBuilder().getOutcomeBuilder().getRelMetadataBuilder().getSemanticsBuilder() != null) {
                        relBuilder.getResultProjectBuilder().getOutcomeBuilder().getRelMetadataBuilder().getSemanticsBuilder().setClassid(REL_CLASS_PRODUCES);
                        relBuilder.getResultProjectBuilder().getOutcomeBuilder().getRelMetadataBuilder().getSemanticsBuilder().setClassname(REL_CLASS_PRODUCES);
                    }
                    builder.setRel(relBuilder.build());
                    builder.setTimestamp(System.currentTimeMillis());
                    return builder.build();
                }
                throw new RuntimeException("invalid state: either source or target relation was missing!");
            }
            throw new RuntimeException("invalid state: no relation object found!");
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return algorithmName;
        }
    }
}

