/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.metadataextraction.schemas.ExtractedDocumentMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class ExtractedDocumentMetadataActionBuilderModuleFactory
implements ActionBuilderFactory<ExtractedDocumentMetadata> {
    private static final AlgorithmName algorithmName = AlgorithmName.document_affiliations;

    @Override
    public ActionBuilderModule<ExtractedDocumentMetadata> instantiate(String predefinedTrust, Configuration config) {
        return new ExtractedDocumentMetadataActionBuilderModule(predefinedTrust, true);
    }

    class ExtractedDocumentMetadataActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<ExtractedDocumentMetadata> {
        private final boolean skipOriginalMetadata;

        public ExtractedDocumentMetadataActionBuilderModule(String predefinedTrust, boolean skipOriginalMetadata) {
            super(predefinedTrust, algorithmName);
            this.skipOriginalMetadata = skipOriginalMetadata;
        }

        @Override
        public List<AtomicAction> build(ExtractedDocumentMetadata object, Agent agent, String actionSetId) {
            OafProtos.Oaf oaf = this.buildOAFMeta(object);
            if (oaf != null) {
                return this.actionFactory.createUpdateActions(actionSetId, agent, object.getId().toString(), TypeProtos.Type.result, oaf.toByteArray());
            }
            return Collections.emptyList();
        }

        protected OafProtos.Oaf buildOAFMeta(ExtractedDocumentMetadata source) {
            ResultProtos.Result result = this.buildResultMeta(source);
            if (result != null || this.shouldExternalIdentifiersBeSet(source)) {
                OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                if (source.getId() != null) {
                    entityBuilder.setId(source.getId().toString());
                }
                entityBuilder.setType(TypeProtos.Type.result);
                if (result != null) {
                    entityBuilder.setResult(result);
                }
                if (this.shouldExternalIdentifiersBeSet(source)) {
                    for (Map.Entry typedId : source.getExternalIdentifiers().entrySet()) {
                        entityBuilder.addPid(this.convertToStructuredProperty((CharSequence)typedId.getValue(), "dnet:pid_types", ((CharSequence)typedId.getKey()).toString()));
                    }
                }
                return this.buildOaf(entityBuilder.build());
            }
            return null;
        }

        private ResultProtos.Result buildResultMeta(ExtractedDocumentMetadata source) {
            ResultProtos.Result.Builder resultBuilder = ResultProtos.Result.newBuilder();
            if (!this.skipOriginalMetadata) {
                FieldTypeProtos.StringField.Builder strFieldBuilder;
                boolean wasBasicMetaModified = false;
                ResultProtos.Result.Metadata.Builder metaBuilder = ResultProtos.Result.Metadata.newBuilder();
                if (source.getTitle() != null) {
                    metaBuilder.addTitle(this.convertToStructuredProperty(source.getTitle(), "dnet:title_typologies", "main title"));
                    wasBasicMetaModified = true;
                }
                if (source.getAbstract$() != null && this.isStringNotEmpty(source.getAbstract$().toString())) {
                    strFieldBuilder = FieldTypeProtos.StringField.newBuilder();
                    strFieldBuilder.setValue(source.getAbstract$().toString());
                    strFieldBuilder.setDataInfo(this.buildInference());
                    metaBuilder.addDescription(strFieldBuilder.build());
                    wasBasicMetaModified = true;
                }
                if (source.getPublisher() != null && this.isStringNotEmpty(source.getPublisher().toString())) {
                    strFieldBuilder = FieldTypeProtos.StringField.newBuilder();
                    strFieldBuilder.setValue(source.getPublisher().toString());
                    strFieldBuilder.setDataInfo(this.buildInference());
                    metaBuilder.setPublisher(strFieldBuilder.build());
                    wasBasicMetaModified = true;
                }
                if (source.getJournal() != null && this.isStringNotEmpty(source.getJournal().toString())) {
                    ResultProtos.Result.Journal.Builder journalBuilder = ResultProtos.Result.Journal.newBuilder();
                    journalBuilder.setName(source.getJournal().toString());
                    metaBuilder.setJournal(journalBuilder.build());
                    wasBasicMetaModified = true;
                }
                if (source.getLanguage() != null && this.isStringNotEmpty(source.getLanguage().toString())) {
                    FieldTypeProtos.Qualifier.Builder qBuilder = FieldTypeProtos.Qualifier.newBuilder();
                    qBuilder.setClassid(source.getLanguage().toString());
                    qBuilder.setClassname(source.getLanguage().toString());
                    qBuilder.setSchemeid("dnet:languages");
                    qBuilder.setSchemename("dnet:languages");
                    metaBuilder.setLanguage(qBuilder.build());
                    wasBasicMetaModified = true;
                }
                if (source.getKeywords() != null && source.getKeywords().size() > 0) {
                    metaBuilder.addAllSubject(this.convertToStructuredProperty(source.getKeywords(), null, null));
                    wasBasicMetaModified = true;
                }
                if (wasBasicMetaModified) {
                    resultBuilder.setMetadata(metaBuilder.build());
                }
            }
            return resultBuilder.hasMetadata() ? resultBuilder.build() : null;
        }

        Collection<FieldTypeProtos.StructuredProperty> convertToStructuredProperty(Collection<CharSequence> source, String defaultScheme, String defaultClass) {
            if (source != null) {
                ArrayList<FieldTypeProtos.StructuredProperty> results = new ArrayList<FieldTypeProtos.StructuredProperty>(source.size());
                for (CharSequence current : source) {
                    results.add(this.convertToStructuredProperty(current, defaultScheme, defaultClass));
                }
                return results;
            }
            return null;
        }

        FieldTypeProtos.StructuredProperty convertToStructuredProperty(CharSequence source, String defaultScheme, String defaultClass) {
            if (source != null) {
                FieldTypeProtos.StructuredProperty.Builder builder = FieldTypeProtos.StructuredProperty.newBuilder();
                builder.setValue(source.toString());
                if (defaultScheme != null || defaultClass != null) {
                    FieldTypeProtos.Qualifier.Builder qBuilder = FieldTypeProtos.Qualifier.newBuilder();
                    if (defaultClass != null) {
                        qBuilder.setClassid(defaultClass);
                        qBuilder.setClassname(defaultClass);
                    }
                    if (defaultScheme != null) {
                        qBuilder.setSchemeid(defaultScheme);
                        qBuilder.setSchemename(defaultScheme);
                    }
                    builder.setQualifier(qBuilder.build());
                }
                return builder.build();
            }
            return null;
        }

        private boolean isStringNotEmpty(String str) {
            return str != null && str.length() > 0;
        }

        private boolean shouldExternalIdentifiersBeSet(ExtractedDocumentMetadata source) {
            return !this.skipOriginalMetadata && source.getExternalIdentifiers() != null && !source.getExternalIdentifiers().isEmpty();
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return algorithmName;
        }
    }
}

