/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module.toxml;

import eu.dnetlib.iis.common.model.extrainfo.converter.AbstractExtraInfoConverter;
import eu.dnetlib.iis.statistics.schemas.AuthorStatistics;
import eu.dnetlib.iis.statistics.schemas.BasicCitationStatistics;
import eu.dnetlib.iis.statistics.schemas.CoAuthor;
import eu.dnetlib.iis.statistics.schemas.CommonCoreStatistics;
import eu.dnetlib.iis.statistics.schemas.CoreStatistics;
import eu.dnetlib.iis.statistics.schemas.ExtendedStatistics;
import java.util.ArrayList;
import java.util.HashMap;

public class AuthorStatisticsXmlConverter
extends AbstractExtraInfoConverter<AuthorStatistics> {
    public AuthorStatisticsXmlConverter() {
        this.xstream.alias("statistics", AuthorStatistics.class);
        this.xstream.alias("coAuthor", CoAuthor.class);
        this.xstream.addImplicitCollection(AuthorStatistics.class, "coAuthors");
    }

    public static void main(String[] args) {
        AuthorStatistics.Builder authorStatsBuilder = AuthorStatistics.newBuilder();
        ArrayList<CoAuthor> coAuthors = new ArrayList<CoAuthor>();
        CoAuthor.Builder coauthorBuilder = CoAuthor.newBuilder();
        coauthorBuilder.setCoauthoredPapersCount(1);
        coauthorBuilder.setId((CharSequence)"someAuthorId");
        coAuthors.add(coauthorBuilder.build());
        coauthorBuilder.setCoauthoredPapersCount(2);
        coauthorBuilder.setId((CharSequence)"someOtherAuthorId");
        coAuthors.add(coauthorBuilder.build());
        authorStatsBuilder.setCoAuthors(coAuthors);
        CommonCoreStatistics.Builder coreStatsBuilder = CommonCoreStatistics.newBuilder();
        CoreStatistics.Builder allPapersStatsBuilder = CoreStatistics.newBuilder();
        allPapersStatsBuilder.setNumberOfPapers(200);
        ExtendedStatistics.Builder fromAllPapersBuilder = ExtendedStatistics.newBuilder();
        fromAllPapersBuilder.setAverageNumberOfCitationsPerPaper(3.5f);
        BasicCitationStatistics.Builder allPapersBasicStatsBuilder = BasicCitationStatistics.newBuilder();
        allPapersBasicStatsBuilder.setNumberOfCitations(500);
        HashMap<String, Integer> allCitationsPerYear = new HashMap<String, Integer>();
        allCitationsPerYear.put("1999", 13);
        allCitationsPerYear.put("1980", 2);
        allPapersBasicStatsBuilder.setNumberOfCitationsPerYear(allCitationsPerYear);
        fromAllPapersBuilder.setBasic(allPapersBasicStatsBuilder.build());
        HashMap<String, Integer> allPapersMap = new HashMap<String, Integer>();
        allPapersMap.put("10", 3);
        fromAllPapersBuilder.setNumberOfPapersCitedAtLeastXTimes(allPapersMap);
        allPapersStatsBuilder.setCitationsFromAllPapers(fromAllPapersBuilder.build());
        ExtendedStatistics.Builder fromPublishedPapersBuilder = ExtendedStatistics.newBuilder();
        fromPublishedPapersBuilder.setAverageNumberOfCitationsPerPaper(2.5f);
        BasicCitationStatistics.Builder publishedPapersBasicStatsBuilder = BasicCitationStatistics.newBuilder();
        publishedPapersBasicStatsBuilder.setNumberOfCitations(200);
        HashMap<String, Integer> publishedCitationsPerYear = new HashMap<String, Integer>();
        publishedCitationsPerYear.put("1980", 13);
        publishedPapersBasicStatsBuilder.setNumberOfCitationsPerYear(allCitationsPerYear);
        fromPublishedPapersBuilder.setBasic(allPapersBasicStatsBuilder.build());
        HashMap publishedPapersMap = new HashMap();
        fromPublishedPapersBuilder.setNumberOfPapersCitedAtLeastXTimes(publishedPapersMap);
        allPapersStatsBuilder.setCitationsFromPublishedPapers(fromPublishedPapersBuilder.build());
        coreStatsBuilder.setAllPapers(allPapersStatsBuilder.build());
        CoreStatistics.Builder publishedPapersStatsBuilder = CoreStatistics.newBuilder();
        publishedPapersStatsBuilder.setNumberOfPapers(100);
        fromAllPapersBuilder = ExtendedStatistics.newBuilder();
        fromAllPapersBuilder.setAverageNumberOfCitationsPerPaper(3.5f);
        allPapersBasicStatsBuilder = BasicCitationStatistics.newBuilder();
        allPapersBasicStatsBuilder.setNumberOfCitations(500);
        allCitationsPerYear = new HashMap();
        allCitationsPerYear.put("2009", 4);
        allPapersBasicStatsBuilder.setNumberOfCitationsPerYear(allCitationsPerYear);
        fromAllPapersBuilder.setBasic(allPapersBasicStatsBuilder.build());
        allPapersMap = new HashMap();
        fromAllPapersBuilder.setNumberOfPapersCitedAtLeastXTimes(allPapersMap);
        publishedPapersStatsBuilder.setCitationsFromAllPapers(fromAllPapersBuilder.build());
        fromPublishedPapersBuilder = ExtendedStatistics.newBuilder();
        fromPublishedPapersBuilder.setAverageNumberOfCitationsPerPaper(2.5f);
        publishedPapersBasicStatsBuilder = BasicCitationStatistics.newBuilder();
        publishedPapersBasicStatsBuilder.setNumberOfCitations(200);
        publishedCitationsPerYear = new HashMap();
        publishedCitationsPerYear.put("2001", 2);
        publishedPapersBasicStatsBuilder.setNumberOfCitationsPerYear(allCitationsPerYear);
        fromPublishedPapersBuilder.setBasic(allPapersBasicStatsBuilder.build());
        publishedPapersMap = new HashMap();
        fromPublishedPapersBuilder.setNumberOfPapersCitedAtLeastXTimes(publishedPapersMap);
        publishedPapersStatsBuilder.setCitationsFromPublishedPapers(fromPublishedPapersBuilder.build());
        coreStatsBuilder.setPublishedPapers(publishedPapersStatsBuilder.build());
        authorStatsBuilder.setCore(coreStatsBuilder.build());
        AuthorStatisticsXmlConverter converter = new AuthorStatisticsXmlConverter();
        System.out.println(converter.serialize(authorStatsBuilder.build()));
    }
}

