/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.iis.documentssimilarity.schemas.DocumentSimilarity;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class DocumentSimilarityActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentSimilarity> {
    private static final AlgorithmName algorithmName = AlgorithmName.document_similarities_standard;
    private final Logger log = Logger.getLogger(this.getClass());

    @Override
    public ActionBuilderModule<DocumentSimilarity> instantiate(String predefinedTrust, Configuration config) {
        String thresholdStr = config.get("export.documentssimilarity.threshold");
        Float threshold = null;
        if (thresholdStr != null && !"$UNDEFINED$".equals(thresholdStr)) {
            threshold = Float.valueOf(thresholdStr);
            this.log.warn((Object)("setting documents similarity exporter threshold to: " + threshold));
        }
        return new DocumentSimilarityActionBuilderModule(predefinedTrust, threshold);
    }

    class DocumentSimilarityActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentSimilarity> {
        private final Float threshold;

        public DocumentSimilarityActionBuilderModule(String predefinedTrust, Float threshold) {
            super(predefinedTrust, algorithmName);
            this.threshold = threshold;
        }

        @Override
        public List<AtomicAction> build(DocumentSimilarity object, Agent agent, String actionSetId) {
            if (object == null) {
                return Collections.emptyList();
            }
            if (this.threshold != null && object.getSimilarity() != null && object.getSimilarity().floatValue() < this.threshold.floatValue()) {
                return Collections.emptyList();
            }
            List<AtomicAction> simActions = this.createActions(object, actionSetId, agent, false);
            List<AtomicAction> reverseSimActions = this.createActions(object, actionSetId, agent, true);
            ArrayList<AtomicAction> results = new ArrayList<AtomicAction>();
            if (simActions != null && !simActions.isEmpty()) {
                results.addAll(simActions);
            }
            if (reverseSimActions != null && !reverseSimActions.isEmpty()) {
                results.addAll(reverseSimActions);
            }
            return results;
        }

        protected List<AtomicAction> createActions(DocumentSimilarity object, String actionSet, Agent agent, boolean backwardMode) {
            OafProtos.Oaf oafObjectRel = this.buildOAFRel(object.getDocumentId().toString(), object.getOtherDocumentId().toString(), object.getSimilarity().floatValue(), backwardMode);
            if (oafObjectRel == null) {
                return Collections.emptyList();
            }
            ArrayList<AtomicAction> actionList = new ArrayList<AtomicAction>();
            AtomicAction currentAction = this.actionFactory.createAtomicAction(actionSet, agent, backwardMode ? object.getOtherDocumentId().toString() : object.getDocumentId().toString(), OafDecoder.decode((OafProtos.Oaf)oafObjectRel).getCFQ(), backwardMode ? object.getDocumentId().toString() : object.getOtherDocumentId().toString(), oafObjectRel.toByteArray());
            actionList.add(currentAction);
            return actionList;
        }

        private OafProtos.Oaf buildOAFRel(String sourceId, String targetDocId, float score, boolean invert) {
            OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
            if (!invert) {
                relBuilder.setSource(sourceId);
                relBuilder.setTarget(targetDocId);
            } else {
                relBuilder.setSource(targetDocId);
                relBuilder.setTarget(sourceId);
            }
            String relClass = invert ? ResultResultProtos.ResultResult.Similarity.RelName.isAmongTopNSimilarDocuments.toString() : ResultResultProtos.ResultResult.Similarity.RelName.hasAmongTopNSimilarDocuments.toString();
            relBuilder.setChild(false);
            relBuilder.setRelType(RelTypeProtos.RelType.resultResult);
            relBuilder.setSubRelType(RelTypeProtos.SubRelType.similarity);
            relBuilder.setRelClass(relClass);
            ResultResultProtos.ResultResult.Builder resultResultBuilder = ResultResultProtos.ResultResult.newBuilder();
            ResultResultProtos.ResultResult.Similarity.Builder similarityBuilder = ResultResultProtos.ResultResult.Similarity.newBuilder();
            similarityBuilder.setRelMetadata(this.buildRelMetadata("dnet:result_result_relations", relClass));
            similarityBuilder.setSimilarity(score);
            similarityBuilder.setType(ResultResultProtos.ResultResult.Similarity.Type.STANDARD);
            resultResultBuilder.setSimilarity(similarityBuilder.build());
            relBuilder.setResultResult(resultResultBuilder.build());
            OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
            oafBuilder.setKind(KindProtos.Kind.relation);
            oafBuilder.setRel(relBuilder.build());
            oafBuilder.setDataInfo(this.buildInference());
            oafBuilder.setTimestamp(System.currentTimeMillis());
            return oafBuilder.build();
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return algorithmName;
        }
    }
}

