/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.documentsclassification.schemas.DocumentClass;
import eu.dnetlib.iis.documentsclassification.schemas.DocumentClasses;
import eu.dnetlib.iis.documentsclassification.schemas.DocumentToDocumentClasses;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class DocumentToDocumentClassesActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentToDocumentClasses> {
    private static final AlgorithmName algorithmName = AlgorithmName.document_classes;

    @Override
    public ActionBuilderModule<DocumentToDocumentClasses> instantiate(String predefinedTrust, Configuration config) {
        return new DocumentToDocumentClassesActionBuilderModule(predefinedTrust);
    }

    class DocumentToDocumentClassesActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentToDocumentClasses> {
        public DocumentToDocumentClassesActionBuilderModule(String predefinedTrust) {
            super(predefinedTrust, algorithmName);
        }

        @Override
        public List<AtomicAction> build(DocumentToDocumentClasses object, Agent agent, String actionSetId) {
            OafProtos.Oaf oaf = this.buildOAFClasses(object);
            if (oaf != null) {
                return this.actionFactory.createUpdateActions(actionSetId, agent, object.getDocumentId().toString(), TypeProtos.Type.result, oaf.toByteArray());
            }
            return Collections.emptyList();
        }

        protected OafProtos.Oaf buildOAFClasses(DocumentToDocumentClasses source) {
            Iterable<? extends FieldTypeProtos.StructuredProperty> classificationSubjects;
            if (source.getClasses() != null && (classificationSubjects = this.convertAvroToProtoBuff(source.getClasses())) != null) {
                OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                ResultProtos.Result.Builder resultBuilder = ResultProtos.Result.newBuilder();
                ResultProtos.Result.Metadata.Builder metaBuilder = ResultProtos.Result.Metadata.newBuilder();
                metaBuilder.addAllSubject(classificationSubjects);
                resultBuilder.setMetadata(metaBuilder.build());
                entityBuilder.setResult(resultBuilder.build());
                entityBuilder.setId(source.getDocumentId().toString());
                entityBuilder.setType(TypeProtos.Type.result);
                return this.buildOaf(entityBuilder.build());
            }
            return null;
        }

        private Iterable<? extends FieldTypeProtos.StructuredProperty> convertAvroToProtoBuff(DocumentClasses source) {
            if (source != null) {
                ArrayList<FieldTypeProtos.StructuredProperty> list = new ArrayList<FieldTypeProtos.StructuredProperty>();
                if (source.getArXivClasses() != null && !source.getArXivClasses().isEmpty()) {
                    list.addAll(this.convertAvroToProtoBuff(source.getArXivClasses(), "arxiv"));
                }
                if (source.getDDCClasses() != null && !source.getDDCClasses().isEmpty()) {
                    list.addAll(this.convertAvroToProtoBuff(source.getDDCClasses(), "ddc"));
                }
                if (source.getWoSClasses() != null && !source.getWoSClasses().isEmpty()) {
                    list.addAll(this.convertAvroToProtoBuff(source.getWoSClasses(), "wos"));
                }
                if (source.getMeshEuroPMCClasses() != null && !source.getMeshEuroPMCClasses().isEmpty()) {
                    list.addAll(this.convertAvroToProtoBuff(source.getMeshEuroPMCClasses(), "mesheuropmc"));
                }
                if (!list.isEmpty()) {
                    return list;
                }
                return null;
            }
            return null;
        }

        private List<FieldTypeProtos.StructuredProperty> convertAvroToProtoBuff(List<DocumentClass> source, String taxonomyName) {
            ArrayList<FieldTypeProtos.StructuredProperty> result = new ArrayList<FieldTypeProtos.StructuredProperty>();
            for (DocumentClass current : source) {
                if (current == null) continue;
                result.add(this.convertAvroToProtoBuff(current, taxonomyName));
            }
            return result;
        }

        private FieldTypeProtos.StructuredProperty convertAvroToProtoBuff(DocumentClass source, String taxonomyName) {
            if (source != null && source.getClassLabels() != null && source.getClassLabels().size() > 0) {
                FieldTypeProtos.StructuredProperty.Builder builder = FieldTypeProtos.StructuredProperty.newBuilder();
                FieldTypeProtos.Qualifier.Builder qualifierBuilder = FieldTypeProtos.Qualifier.newBuilder();
                qualifierBuilder.setSchemeid("dnet:subject_classification_typologies");
                qualifierBuilder.setSchemename("dnet:subject_classification_typologies");
                qualifierBuilder.setClassid(taxonomyName);
                qualifierBuilder.setClassname(taxonomyName);
                builder.setQualifier(qualifierBuilder.build());
                builder.setValue(StringUtils.join((Collection)source.getClassLabels(), (String)"::"));
                Float confidenceLevel = source.getConfidenceLevel();
                if (confidenceLevel != null) {
                    builder.setDataInfo(this.buildInference(confidenceLevel.floatValue() < 1.0f ? confidenceLevel.floatValue() : 1.0f));
                } else {
                    builder.setDataInfo(this.buildInference());
                }
                return builder.build();
            }
            return null;
        }

        @Override
        public AlgorithmName getAlgorithName() {
            return algorithmName;
        }
    }
}

