/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.statistics.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

public class GenerateCoauthorsUDF
extends GenericUDF {
    private StringObjectInspector authorIdOI;
    private MapObjectInspector mapOI;
    private StringObjectInspector mapKeyOI;
    private IntObjectInspector mapValueOI;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("GenerateCoauthorsUDF takes 2 argument: string, map<string, int>");
        }
        if (!(arguments[0] instanceof StringObjectInspector)) {
            throw new UDFArgumentException("The argument must be a list");
        }
        this.authorIdOI = (StringObjectInspector)arguments[0];
        if (!(arguments[1] instanceof MapObjectInspector)) {
            throw new UDFArgumentException("The argument must be a list");
        }
        this.mapOI = (MapObjectInspector)arguments[1];
        if (!(this.mapOI.getMapKeyObjectInspector() instanceof StringObjectInspector)) {
            throw new UDFArgumentException("The argument must be a list");
        }
        this.mapKeyOI = (StringObjectInspector)this.mapOI.getMapKeyObjectInspector();
        if (!(this.mapOI.getMapValueObjectInspector() instanceof IntObjectInspector)) {
            throw new UDFArgumentException("The argument must be a list");
        }
        this.mapValueOI = (IntObjectInspector)this.mapOI.getMapValueObjectInspector();
        List<String> names = Arrays.asList("id", "coauthoredPapersCount");
        List<AbstractPrimitiveWritableObjectInspector> ois = Arrays.asList(PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(names, ois));
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        ArrayList<Object[]> coauthors = new ArrayList<Object[]>();
        String key = this.authorIdOI.getPrimitiveJavaObject(arguments[0].get());
        Map map = this.mapOI.getMap(arguments[1].get());
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                Map.Entry mapEntry = entry;
                String id = this.mapKeyOI.getPrimitiveJavaObject(mapEntry.getKey());
                if (id.equals(key)) continue;
                int count = this.mapValueOI.get(mapEntry.getValue());
                Object[] coauthor = new Object[]{new Text(id), new IntWritable(count)};
                coauthors.add(coauthor);
            }
        }
        return coauthors;
    }

    public String getDisplayString(String[] strings) {
        return "GenerateCoauthors()";
    }
}

