/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.statsmanager;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.Base64Converter;

public class CacheController {
    private HashMap<String, URL> actions;
    private Logger log = Logger.getLogger(this.getClass());
    private String httpsCredentials;

    public CacheController() {
    }

    public void executeCommand(String action, Map<String, String> parameters) throws Exception {
        String urlString = this.actions.get(action).toString();
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            if (e.getKey().equals("cache") || e.getKey().equals("error")) continue;
            urlString = urlString + "&" + e.getKey() + "=" + e.getValue();
        }
        this.executeRemoteScript(new URL(urlString));
    }

    private void executeRemoteScript(URL url) throws Exception {
        try {
            String inputLine;
            Base64Converter converter = new Base64Converter();
            BufferedReader in = null;
            if (url.toString().startsWith("https://")) {
                String encoding = converter.encode(this.httpsCredentials.getBytes("UTF-8"));
                this.log.info((Object)("Using https : " + url.toString()));
                HttpsURLConnection yc = (HttpsURLConnection)url.openConnection();
                yc.setRequestProperty("Authorization", String.format("Basic %s", encoding));
                in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            } else {
                this.log.info((Object)("Using normal url : " + url.toString()));
                URLConnection yc = url.openConnection();
                in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            }
            while ((inputLine = in.readLine()) != null) {
                this.log.info((Object)inputLine);
            }
            in.close();
        }
        catch (Exception e) {
            this.log.error((Object)("Error while calling php script over http. Reason: " + e));
            throw new Exception(e);
        }
    }

    public HashMap<String, URL> getActions() {
        return this.actions;
    }

    public void setActions(HashMap<String, URL> actions) {
        this.actions = actions;
    }

    public CacheController(HashMap<String, URL> actions) {
        this.actions = actions;
    }

    public String getHttpsCredentials() {
        return this.httpsCredentials;
    }

    public void setHttpsCredentials(String httpsCredentials) {
        this.httpsCredentials = httpsCredentials;
    }
}

