package eu.dnetlib.data.statsmanager;

import org.apache.log4j.Logger;

import javax.xml.bind.annotation.XmlRootElement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by antleb on 10/25/14.
 */


@XmlRootElement(name = "ValidationReport")
public class ValidationReport {

    private ArrayList<Query> Queries;

    private Date validationDate;
    private Logger log = Logger.getLogger(this.getClass());

    public ValidationReport() {
        DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        this.validationDate = new Date();
        Queries = new ArrayList<Query>();
    }


    public void addQuery(String id,String name, int sqlResult, int cqlResult, boolean status)

    {
        Query q = new Query(id,name, sqlResult, cqlResult, status);
        this.getQueries().add(q);


    }
    /*
    DB validation report. Contains:
	- queries:
	  - query name
	  - db result
	  - cql result
	  - status (success/fail)
	- metadata:
	  - validation date
	  - ???
	 */

    public ArrayList<Query> getQueries() {
        return Queries;
    }

    public void setQueries(ArrayList<Query> queries) {
        Queries = queries;
    }

    @Override
    public String toString() {
        return "ValidationReport{" +
                "Queries=" + Queries +
                ", validationDate=" + validationDate +
                '}';
    }

    public Date getValidationDate() {
        return validationDate;
    }

    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }
}
