/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.statsmanager;

import eu.dnetlib.data.statsmanager.CacheController;
import eu.dnetlib.data.statsmanager.ValidationReport;
import eu.dnetlib.data.statsmanager.Validator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

public class StatsManager {
    private Validator validator;
    private ValidationReport validationReport;
    private DataSource dataSource;
    private CacheController prodCacheController;
    private CacheController testCacheController;
    private Logger log = Logger.getLogger(this.getClass());

    public ValidationReport validateDatabase() throws Exception {
        this.validationReport = this.validator.validateDatabase();
        return this.validationReport;
    }

    @Transactional
    public void promoteShadowSchema() throws Exception {
        Connection con = this.dataSource.getConnection();
        this.log.info((Object)("Backing up and Replacing public schema  with shadow in " + this.dataSource.getConnection().getMetaData().getURL() + " ..."));
        con.createStatement().execute("drop schema if exists backup CASCADE ;");
        con.createStatement().execute("alter schema public rename to backup ;");
        con.createStatement().execute("alter schema  shadow rename TO public ;");
        this.log.info((Object)"All ops done!");
        con.close();
    }

    public void executeCacheAction(BlackboardJob job) throws Exception {
        if (job.getAction().equals("refreshCache")) {
            this.executeCommand("refreshAll", job.getParameters());
        } else if (job.getAction().equals("refreshCharts")) {
            this.executeCommand(job.getAction(), job.getParameters());
        } else if (job.getAction().equals("refreshNums")) {
            this.executeCommand(job.getAction(), job.getParameters());
        } else if (job.getAction().equals("promoteShadow")) {
            this.executeCommand("promoteAll", job.getParameters());
            this.promoteShadowSchema();
        } else if (job.getAction().equals("promoteNums")) {
            this.executeCommand(job.getAction(), job.getParameters());
        } else if (job.getAction().equals("promoteCharts")) {
            this.executeCommand(job.getAction(), job.getParameters());
        } else if (job.getAction().equals("promoteCache")) {
            this.executeCommand("promoteAll", job.getParameters());
        } else if (job.getAction().equals("restore")) {
            this.executeCommand(job.getAction(), job.getParameters());
        } else if (job.getAction().equals("migrate")) {
            this.executeCommand(job.getAction(), job.getParameters());
        } else if (job.getAction().equals("backup")) {
            this.executeCommand(job.getAction(), job.getParameters());
        } else {
            this.log.error((Object)"Wrong action given ");
            throw new Exception("Wrong action given ");
        }
        this.log.info((Object)"Done ! ");
    }

    private void executeCommand(String action, Map<String, String> parameters) throws Exception {
        String cache = parameters.get("cache");
        this.log.info((Object)("Executing  action " + action + " in " + cache + "..."));
        if (cache == null || cache.contains("test")) {
            this.testCacheController.executeCommand(action, parameters);
        } else if (cache.contains("beta") || cache.contains("production")) {
            this.prodCacheController.executeCommand(action, parameters);
        } else {
            throw new Exception("Wrong cache id");
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public ValidationReport getValidationReport() {
        return this.validationReport;
    }

    public void setValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
    }

    public CacheController getProdCacheController() {
        return this.prodCacheController;
    }

    public void setProdCacheController(CacheController prodCacheController) {
        this.prodCacheController = prodCacheController;
    }

    public CacheController getTestCacheController() {
        return this.testCacheController;
    }

    public void setTestCacheController(CacheController testCacheController) {
        this.testCacheController = testCacheController;
    }
}

