/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.executors;

import eu.dnetlib.validator.engine.data.Provider;
import eu.dnetlib.validator.engine.data.ResultSet;
import eu.dnetlib.validator.engine.data.Rule;
import eu.dnetlib.validator.engine.execution.Executor;
import eu.dnetlib.validator.engine.execution.JobListener;
import eu.dnetlib.validator.engine.execution.Task;
import eu.dnetlib.validator.engine.execution.TaskList;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.executors.ExecutorSubmitter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

@Deprecated
public class ThreadExecutorSubmitter
extends ExecutorSubmitter {
    private transient Logger log = Logger.getLogger(ThreadExecutorSubmitter.class);
    public final Executor executor;
    public final long timeout;
    public final long generalTimeout;
    public final String set;
    private Map<String, Object> recordContext;

    public ThreadExecutorSubmitter(int jobId, Set<Rule> rules, String set, Provider provider, JobListener validatorListener, Executor executor, long timeout, long generalTimeout, JobListener ... listeners) {
        super(jobId, rules, set, provider, new HashMap(), validatorListener, listeners);
        this.log.debug((Object)("Creating a new executor submitter with timeout " + timeout + " and general timeout " + generalTimeout));
        this.executor = executor;
        this.timeout = timeout;
        this.generalTimeout = generalTimeout;
        this.set = set;
    }

    public void submit() throws ExecutorSubmitter.ExecutionException {
        long elapsed = 0L;
        int count = 0;
        int record_limit = -1;
        this.log.debug((Object)"Submitting job");
        if (this.provider.getConfiguration().getProperty("records") != null && !this.provider.getConfiguration().getProperty("records").trim().equals("-1")) {
            record_limit = Integer.parseInt(this.provider.getConfiguration().getProperty("records").trim());
        }
        if (this.provider.getConfiguration().getProperty("RECORDS") != null && !this.provider.getConfiguration().getProperty("RECORDS").trim().equals("-1")) {
            record_limit = Integer.parseInt(this.provider.getConfiguration().getProperty("RECORDS").trim());
        }
        this.log.debug((Object)("Number of records to validate: " + record_limit + " (-1 for all)"));
        Boolean crisFlag = false;
        if (this.set != null && this.set.contains("_cris_")) {
            crisFlag = true;
        }
        boolean success = false;
        ArrayList<Task> tasks = new ArrayList<Task>();
        ResultSet ivobjs = null;
        try {
            if (!crisFlag.booleanValue()) {
                this.log.debug((Object)"request to get validation objects without set..");
                ivobjs = this.provider.getValidationObjects();
            } else {
                this.log.debug((Object)("request to get validation objects with set: " + this.set));
                ivobjs = this.provider.getValidationObjects(this.set);
            }
        }
        catch (Provider.ProviderException e1) {
            this.log.error((Object)"Error while getting validation objects from provider", (Throwable)e1);
            for (JobListener listener : this.listeners) {
                listener.failed(this.jobId, this.jobContext, (Throwable)e1);
            }
        }
        block7: while (true) {
            try {
                while ((count < record_limit || record_limit == -1) && ivobjs.next()) {
                    this.recordContext = new HashMap();
                    tasks.clear();
                    ValidationObject vobj = (ValidationObject)ivobjs.get();
                    this.log.debug((Object)("Checking if rules will be applied on object " + vobj.getId()));
                    if (vobj.getStatus() != null && vobj.getStatus().equalsIgnoreCase("deleted")) {
                        this.log.debug((Object)"Object is deleted and will be ignored");
                        continue;
                    }
                    if (crisFlag.booleanValue() && (vobj.getId().contains("cfEAddr") || vobj.getId().contains("cfEquip"))) {
                        this.log.debug((Object)"ignoring cfEaddr and cfEquip records from persons and datasets");
                        continue;
                    }
                    this.log.debug((Object)("Applying rules on object " + vobj.getId()));
                    ++count;
                    for (Rule rule : this.rules) {
                        if (rule == null) continue;
                        rule.setValObjId(vobj.getId());
                        rule.setProvider(this.provider);
                        Task task = new Task(vobj, rule);
                        tasks.add(task);
                    }
                    TaskList ltasks = new TaskList(tasks);
                    try {
                        long time1 = Calendar.getInstance().getTimeInMillis() / 1000L;
                        this.executor.execute(ltasks).get(this.timeout, TimeUnit.SECONDS);
                        long time2 = Calendar.getInstance().getTimeInMillis() / 1000L;
                        this.log.debug((Object)("Task execution took " + (time2 - time1) + " seconds"));
                        this.log.debug((Object)("Elapsed time till now is " + (elapsed += time2 - time1) + " seconds"));
                        if (elapsed > this.generalTimeout) {
                            throw new ExecutorSubmitter.ExecutionException((ExecutorSubmitter)this, "Job timed out");
                        }
                        for (JobListener listener : this.listeners) {
                            listener.currentResults(ltasks.getCtasks(), this.jobId, vobj.getContentAsObject(), this.recordContext);
                        }
                        success = true;
                        continue block7;
                    }
                    catch (Exception e) {
                        this.log.error((Object)"an error occured while executing tasks: ", (Throwable)e);
                        for (JobListener listener : this.listeners) {
                            listener.currentResults(ltasks.getCtasks(), this.jobId, vobj.getContentAsObject(), this.recordContext, (Throwable)e);
                        }
                    }
                }
                break;
            }
            catch (Exception e) {
                this.log.error((Object)"data error", (Throwable)e);
                for (JobListener listener : this.listeners) {
                    listener.failed(this.jobId, this.jobContext, (Throwable)e);
                }
                break;
            }
        }
        if (success) {
            for (JobListener listener : this.listeners) {
                listener.finished(this.jobId, this.jobContext);
            }
        } else {
            this.log.error((Object)"an error occured");
            for (JobListener listener : this.listeners) {
                if (ivobjs.getError() == null) {
                    listener.failed(this.jobId, this.jobContext, (Throwable)new ExecutorSubmitter.ExecutionException((ExecutorSubmitter)this, "All tasks failed"));
                    continue;
                }
                listener.failed(this.jobId, this.jobContext, (Throwable)new ExecutorSubmitter.ExecutionException((ExecutorSubmitter)this, ivobjs.getError()));
                this.log.error((Object)"an error occured.", (Throwable)new ExecutorSubmitter.ExecutionException((ExecutorSubmitter)this, ivobjs.getError()));
            }
        }
    }
}

