/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.listeners;

import eu.dnetlib.validator.commons.dao.jobs.JobsDAO;
import eu.dnetlib.validator.commons.email.Emailer;
import eu.dnetlib.validator.engine.execution.CompletedTask;
import eu.dnetlib.validator.engine.execution.JobListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class CompatibilityTestListener
implements JobListener {
    private static Logger logger = Logger.getLogger(CompatibilityTestListener.class);
    private Emailer emailer = null;
    private String valBaseUrl = null;
    private String validationSet = null;
    private String guidelines = null;
    private JobsDAO jobsDao;
    private int totalJobs;
    private int jobsFinished = 0;

    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void finished(int jobId, Map<String, Object> jobContext) {
        try {
            ++this.jobsFinished;
            if (this.jobsFinished == this.totalJobs) {
                logger.debug((Object)"all jobs finished");
                this.jobsDao.setTotalJobFinished(jobId, null, Boolean.valueOf(false));
                this.sendMail(((Integer)jobContext.get("jobSubmittedId")).intValue(), (String)jobContext.get("jobSubmittedUser"));
            } else {
                logger.debug((Object)("not all jobs finished yet. Waiting " + (this.totalJobs - this.jobsFinished) + " job(s) to finish"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while finalizing successfull compatibility test job", (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void failed(int jobId, Map<String, Object> jobContext, Throwable t) {
        try {
            ++this.jobsFinished;
            if (this.jobsFinished == this.totalJobs) {
                this.jobsDao.setTotalJobFinished(jobId, t.getMessage(), Boolean.valueOf(true));
                this.sendMail(((Integer)jobContext.get("jobSubmittedId")).intValue(), (String)jobContext.get("jobSubmittedUser"));
            } else {
                logger.debug((Object)("not all jobs finished yet. Waiting " + (this.totalJobs - this.jobsFinished) + " job(s) to finish"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while finalizing failed compatibility test job", (Throwable)e);
        }
    }

    private void sendMail(int jobSubmittedId, String jobSubmittedUser) {
        logger.debug((Object)("JOBID:" + jobSubmittedId + "# Sending email for finished job"));
        String mailTo = jobSubmittedUser;
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(mailTo);
        String msgUpgrade = "";
        if (this.guidelines.equalsIgnoreCase("openaire2.0") || this.guidelines.equalsIgnoreCase("driver")) {
            msgUpgrade = "\n\n Please consider to upgrade to OpenAIRE Guidelines v3. Link: https://guidelines.openaire.eu/wiki/OpenAIRE_Guidelines:_For_Literature_repositories";
        }
        String message = "The compatibility test you have submitted has finished. You can retrieve the results by following this url: " + this.valBaseUrl + "/prepareSummary.action?jobId=" + jobSubmittedId + msgUpgrade;
        String subject = "OpenAIRE compatibility Test Results";
        try {
            this.emailer.sendMail(recipients, subject, message, false, null);
        }
        catch (Exception e) {
            logger.error((Object)("JOBID:" + jobSubmittedId + "# Error sending email for finished job"), (Throwable)e);
        }
    }

    public void currentResults(List<CompletedTask> tasks, int jobId, Object object, Map<String, Object> recordContext, Throwable t) {
    }

    public void currentResults(List<CompletedTask> tasks, int jobId, Object object, Map<String, Object> recordContext) {
    }

    public String getValBaseUrl() {
        return this.valBaseUrl;
    }

    public void setValBaseUrl(String valBaseUrl) {
        this.valBaseUrl = valBaseUrl;
    }

    public String getValidationSet() {
        return this.validationSet;
    }

    public void setValidationSet(String validationSet) {
        this.validationSet = validationSet;
    }

    public Emailer getEmailer() {
        return this.emailer;
    }

    public void setEmailer(Emailer emailer) {
        this.emailer = emailer;
    }

    public String getGuidelines() {
        return this.guidelines;
    }

    public void setGuidelines(String guidelines) {
        this.guidelines = guidelines;
    }

    public int getTotalJobs() {
        return this.totalJobs;
    }

    public void setTotalJobs(int totalJobs) {
        this.totalJobs = totalJobs;
    }

    public JobsDAO getJobsDao() {
        return this.jobsDao;
    }

    public void setJobsDao(JobsDAO jobsDao) {
        this.jobsDao = jobsDao;
    }
}

