/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impl;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.validator.service.impl.ValidatorManager;
import org.apache.log4j.Logger;

public class NotificationListener
extends BlackboardNotificationHandler<BlackboardServerHandler> {
    private static Logger logger = Logger.getLogger(NotificationListener.class);
    private ValidatorManager valManager;

    protected void processJob(BlackboardJob job) {
        block12: {
            String blacklistedRecords;
            String blacklistGuidelines;
            super.processJob(job);
            logger.debug((Object)"New Job!");
            String type = (String)job.getParameters().get("type");
            String mdstoreId = (String)job.getParameters().get("mdstoreId");
            String guidelines = (String)job.getParameters().get("guidelines");
            String groupBy = (String)job.getParameters().get("groupBy");
            String records = (String)job.getParameters().get("records");
            String outputEpr = (String)job.getParameters().get("outputEpr");
            if (outputEpr == null) {
                outputEpr = "false";
            }
            if ((blacklistGuidelines = (String)job.getParameters().get("blacklistGuidelines")) == null) {
                blacklistGuidelines = guidelines;
            }
            if ((blacklistedRecords = (String)job.getParameters().get("blacklistedRecords")) == null) {
                blacklistedRecords = "false";
            }
            String submissionDate = (String)job.getParameters().get("submissionDate");
            String jobStatusUpdateInterval = (String)job.getParameters().get("jobStatusUpdateInterval");
            String datasourceId = (String)job.getParameters().get("datasourceId");
            String baseUrl = (String)job.getParameters().get("baseUrl");
            String datasourceNamespacePrefix = (String)job.getParameters().get("datasourceNamespacePrefix");
            String datasourceName = (String)job.getParameters().get("datasourceName");
            String extra_param = (String)job.getParameters().get("extra_param");
            try {
                int workers = 1;
                int recordsInt = 0;
                int jobStatusUpdateIntervalInt = 100;
                recordsInt = records == null || records.equalsIgnoreCase("all") ? -1 : Integer.parseInt(records);
                workers = recordsInt > -1 && recordsInt < 100 ? 1 : 4;
                if (job.getParameters().get("workers") != null) {
                    workers = Integer.parseInt((String)job.getParameters().get("workers"));
                }
                if (jobStatusUpdateInterval != null) {
                    jobStatusUpdateIntervalInt = Integer.parseInt(jobStatusUpdateInterval);
                }
                if (recordsInt != 0) {
                    logger.debug((Object)("New Job of type: " + type + " - workers: " + workers + " - recordsInt: " + recordsInt));
                    logger.debug((Object)("workers: " + workers));
                    logger.debug((Object)("recordsInt: " + recordsInt));
                    logger.debug((Object)("jobStatusUpdateInterval: " + jobStatusUpdateIntervalInt));
                    if (job.getAction().equalsIgnoreCase("VALIDATE")) {
                        if (type.equalsIgnoreCase("OAI")) {
                            logger.debug((Object)"type is oai");
                        } else if (type.equalsIgnoreCase("DNET")) {
                            logger.debug((Object)"type is dnet");
                            logger.debug((Object)("groupBy: " + groupBy));
                            this.valManager.beginDataJobForWorkflow(mdstoreId, guidelines, groupBy, recordsInt, workers, job, (BlackboardNotificationHandler)this, jobStatusUpdateIntervalInt, Boolean.parseBoolean(outputEpr), Boolean.parseBoolean(blacklistedRecords), blacklistGuidelines);
                        }
                        break block12;
                    }
                    throw new Exception("Unknown action");
                }
                throw new Exception("There are no records in the MDStore.");
            }
            catch (Exception e) {
                logger.error((Object)"Failed to begin the workflow for the job received", (Throwable)e);
                ((BlackboardServerHandler)this.getBlackboardHandler()).failed(job, (Throwable)e);
            }
        }
    }

    public ValidatorManager getValManager() {
        return this.valManager;
    }

    public void setValManager(ValidatorManager valManager) {
        this.valManager = valManager;
    }
}

