/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.listeners;

import eu.dnetlib.api.data.DatasourceManagerService;
import eu.dnetlib.validator.commons.dao.jobs.JobsDAO;
import eu.dnetlib.validator.commons.email.Emailer;
import eu.dnetlib.validator.engine.execution.CompletedTask;
import eu.dnetlib.validator.engine.execution.JobListener;
import gr.uoa.di.driver.util.ServiceLocator;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class RegistrationListener
implements JobListener {
    private Emailer emailer = null;
    private String valBaseUrl = null;
    private JobsDAO jobsDao;
    private ServiceLocator<DatasourceManagerService> dmService = null;
    private static final int BASE_SCORE = 50;
    private int jobId;
    private String activationId;
    private String userMail;
    private String officialName;
    private String baseUrl;
    private String datasourceId;
    private String interfaceId;
    private String interfaceIdOld;
    private String validationSet;
    private String desiredCompLevel;
    private String repoType;
    private String msgSubject;
    private boolean updateExisting;
    private List<String> adminEmails;
    private boolean job1Success = false;
    private boolean job2Success = false;
    private boolean critFailDone = false;
    private int totalJobs;
    private int jobsFinished = 0;
    private int score_content = 0;
    private int score_usage = 0;
    private static Logger logger = Logger.getLogger(RegistrationListener.class);

    public RegistrationListener() {
        logger.debug((Object)("Creating a pre-registration listener for job " + this.jobId + " on repo " + this.baseUrl));
    }

    public synchronized void jobSuccess(int jobId, int score_content, int score_usage) {
        logger.debug((Object)("Preregistration job " + jobId + " finished"));
        this.score_content = score_content;
        this.score_usage = score_usage;
        this.jobId = jobId;
        if (score_content >= 50) {
            this.job1Success = true;
        }
        if (score_usage >= 50) {
            this.job2Success = true;
        }
        if (this.job1Success == this.job2Success) {
            this.criticalSuccess();
        } else {
            if (!this.critFailDone) {
                this.criticalFailure();
            }
            this.critFailDone = true;
        }
    }

    public synchronized void jobFailure(int jobId, String error) {
        logger.debug((Object)("Pregistration job " + jobId + " failed with exception: " + error));
        this.jobId = jobId;
        if (!this.critFailDone) {
            this.criticalFailure();
        }
        this.critFailDone = true;
    }

    private void criticalSuccess() {
        try {
            String msgOpenaireV2 = "OpenAIRE v2, please consider to upgrade to OpenAIRE Guidelines v3. Link: https://guidelines.openaire.eu/wiki/OpenAIRE_Guidelines:_For_Literature_repositories";
            String msgDriver = "OpenAIRE Basic (ex DRIVER) Guidelines, please consider to upgrade to OpenAIRE Guidelines v3. Link: https://guidelines.openaire.eu/wiki/OpenAIRE_Guidelines:_For_Literature_repositories";
            String msgOpenaireV3 = "OpenAIRE Guidelines v3 (for literature)";
            String msgOpenaireV2_data = "OpenAIRE Guidelines v2 (for data archives)";
            String msgVersion = msgOpenaireV3;
            String msg100 = "\n\nWe also encourage you to display the following logo at your repository's/journal's homepage to indicate that it is 100% OpenAIRE compliant: " + this.valBaseUrl + "/jsps/images/compliant.png";
            String msgInformUser = "An email has been send to the repository's/journal's administrators to inform them about this registration";
            String msgInformAdmins = "The " + this.repoType + " was registered by user: " + this.userMail + " , who is not listed as repository's/journal's administrator. If you have any concerns, please visit " + this.valBaseUrl + " to edit your repository's/journal's information. Please Sign in or Register with this email address.";
            String msgGuidelines = "OpenAIRE Guidelines v3 (for literature)";
            logger.debug((Object)("Critical Success of pre-registration validations on repo: " + this.baseUrl + " and set: " + this.validationSet + " with scores (" + this.score_content + ", " + this.score_usage + ")"));
            if (this.desiredCompLevel.equalsIgnoreCase("openaire2.0")) {
                msgVersion = msgOpenaireV2;
                msgGuidelines = "OpenAIRE For Literature Repositories (OpenAIRE 2.0)";
            } else if (this.desiredCompLevel.equalsIgnoreCase("driver")) {
                msgVersion = msgDriver;
                msgGuidelines = "OpenAIRE For Literature Repositories (Basic - ex DRIVER)";
            } else if (this.desiredCompLevel.equalsIgnoreCase("openaire2.0_data")) {
                msgVersion = msgOpenaireV2_data;
                msgGuidelines = "OpenAIRE For Data Archives (OpenAIRE 2.0)";
            } else if (this.desiredCompLevel.equalsIgnoreCase("openaire3.0")) {
                msgVersion = msgOpenaireV3;
                msgGuidelines = "OpenAIRE For Literature Repositories (OpenAIRE 3.0)";
            }
            if (this.score_content == 100 && this.score_usage == 100) {
                this.emailer.sendMail(this.adminEmails, this.getMsgSubject() + "- Test Results [" + this.officialName + "]", "Congratulations!! Your " + this.repoType + " has successfully passed the test to become compliant with " + msgVersion + "." + msg100, false, null);
            } else {
                this.emailer.sendMail(this.adminEmails, this.getMsgSubject() + "- Test Results [" + this.officialName + "]", "Congratulations!! Your " + this.repoType + " has successfully passed the test to become compliant with " + msgVersion + ".", false, null);
            }
            this.updateRepositoryInterfaceCompliance(this.officialName, this.datasourceId, this.interfaceId, this.desiredCompLevel, this.validationSet, this.baseUrl, this.interfaceIdOld);
            ArrayList<String> rec = new ArrayList<String>();
            rec.add(this.userMail);
            if (this.adminEmails.contains(this.userMail)) {
                this.emailer.sendMail(rec, this.getMsgSubject() + "- Results [" + this.officialName + "]", "The compatibility test of your " + this.repoType + " was successful. Nevertheless, some erros might still exist. We strongly recommend reviewing the results and correcting any errors found:\n" + this.valBaseUrl + "/prepareSummary.action?jobId=" + this.jobId + "\n", false, null);
            } else {
                this.emailer.sendMail(rec, this.getMsgSubject() + "- Results [" + this.officialName + "]", "The compatibility test of your " + this.repoType + " was successful. Nevertheless, some erros might still exist. We strongly recommend reviewing the results and correcting any errors found:\n" + this.valBaseUrl + "/prepareSummary.action?jobId=" + this.jobId + "\n\n" + msgInformUser, false, null);
                rec.clear();
                rec.addAll(this.adminEmails);
                this.emailer.sendMail(rec, this.getMsgSubject() + "- Results [" + this.officialName + "]", "The compatibility test of your " + this.repoType + " was successful. Nevertheless, some erros might still exist. We strongly recommend reviewing the results and correcting any errors found:\n" + this.valBaseUrl + "/prepareSummary.action?jobId=" + this.jobId + "\n\n" + msgInformAdmins, false, null);
            }
            rec.clear();
            if (this.isUpdateExisting()) {
                this.emailer.sendMail(rec, this.getMsgSubject() + "- Results (success) [" + this.officialName + "]", "An OpenAIRE compliant " + this.repoType + " has been updated." + "\n\nOfficial Name: " + this.officialName + "\n\nBase URL: " + this.baseUrl + "\n\nValidation Set: " + this.validationSet + "\n\nGuidelines: " + msgGuidelines, true, null);
            } else {
                this.emailer.sendMail(rec, this.getMsgSubject() + "- Results (success) [" + this.officialName + "]", "A new " + this.repoType + " is ready to be added in the OpenAIRE compliant list." + "\n\nOfficial Name: " + this.officialName + "\n\nBase URL: " + this.baseUrl + "\n\nValidation Set: " + this.validationSet + "\n\nGuidelines: " + msgGuidelines, true, null);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void criticalFailure() {
        try {
            String msgGuidelines = "OpenAIRE For Literature Repositories (OpenAIRE 3.0)";
            if (this.desiredCompLevel.equalsIgnoreCase("openaire2.0")) {
                msgGuidelines = "OpenAIRE For Literature Repositories (OpenAIRE 2.0)";
            } else if (this.desiredCompLevel.equalsIgnoreCase("driver")) {
                msgGuidelines = "OpenAIRE For Literature Repositories (Basic - ex DRIVER)";
            } else if (this.desiredCompLevel.equalsIgnoreCase("openaire2.0_data")) {
                msgGuidelines = "OpenAIRE For Data Archives (OpenAIRE 2.0)";
            } else if (this.desiredCompLevel.equalsIgnoreCase("openaire3.0")) {
                msgGuidelines = "OpenAIRE For Literature Repositories (OpenAIRE 3.0)";
            }
            logger.debug((Object)("Critical Failure of pre-registration validations on repo " + this.baseUrl));
            ArrayList<String> rec = new ArrayList<String>();
            rec.add(this.userMail);
            this.emailer.sendMail(rec, this.getMsgSubject() + "- Results [" + this.officialName + "]", "The compatibility test of your " + this.repoType + " on repo: " + this.baseUrl + " and set: " + this.validationSet + " was unsuccessful and the join process has failed. \n" + "Your Scores: " + this.score_content + "/100 and " + this.score_usage + "/100 . Score required to pass: >50 \n" + " Please review the results and correct any errors: \n" + this.valBaseUrl + "/prepareSummary.action?jobId=" + this.jobId + "\n", false, null);
            this.emailer.sendMail(new ArrayList(), this.getMsgSubject() + "- Results (failure) [" + this.officialName + "]", "The compatibility test on " + this.officialName + " was unsuccessful and the join process has failed. " + "\n\nOfficial Name: " + this.officialName + "\n\nBase URL: " + this.baseUrl + "\n\nValidation Set: " + this.validationSet + "\n\nGuidelines: " + msgGuidelines + "\n\nReview the validation results here: \n" + this.valBaseUrl + "/prepareSummary.action?jobId=" + this.jobId + "\n", true, null);
            this.updateRepositoryInterfaceCompliance(this.officialName, this.datasourceId, this.interfaceId, "notCompatible", this.validationSet, this.baseUrl, this.interfaceIdOld);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void finished(int jobId, Map<String, Object> jobContext) {
        try {
            ++this.jobsFinished;
            if (jobContext.containsKey("score_content")) {
                this.score_content = (Integer)jobContext.get("score_content");
            } else if (jobContext.containsKey("score_usage")) {
                this.score_usage = (Integer)jobContext.get("score_usage");
            }
            if (this.jobsFinished == this.totalJobs) {
                logger.debug((Object)"all jobs for registration finished");
                this.jobsDao.setTotalJobFinished(jobId, null, Boolean.valueOf(false));
                logger.debug((Object)("id:" + jobId + "c: " + this.score_content + " u:" + this.score_usage));
                this.jobSuccess(((Integer)jobContext.get("jobSubmittedId")).intValue(), this.score_content, this.score_usage);
            } else {
                logger.debug((Object)("not all jobs finished yet. Waiting " + (this.totalJobs - this.jobsFinished) + " job(s) to finish"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while finalizing successfull registration job");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized void failed(int jobId, Map<String, Object> jobContext, Throwable t) {
        try {
            this.jobsDao.setTotalJobFinished(jobId, t.getMessage(), Boolean.valueOf(true));
            this.jobFailure(((Integer)jobContext.get("jobSubmittedId")).intValue(), t.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)"Error while finalizing failed registration job");
        }
    }

    public boolean updateRepositoryInterfaceCompliance(String officialName, String datasourceId, String interfaceId, String desiredCompliance, String set, String baseUrl, String oldId) throws Exception {
        boolean ret = true;
        try {
            if (desiredCompliance.equalsIgnoreCase("openaire2.0_data")) {
                desiredCompliance = "openaire2.0";
            }
            logger.debug((Object)("updating repository " + officialName + " compliance to : " + desiredCompliance));
            if (oldId == null) {
                ((DatasourceManagerService)this.dmService.getService()).updateLevelOfCompliance(datasourceId, interfaceId, desiredCompliance);
            } else {
                logger.debug((Object)"Checking if old interface should be updated");
                if (!desiredCompliance.equalsIgnoreCase("UNKNOWN") && !desiredCompliance.equalsIgnoreCase("notCompatible")) {
                    logger.debug((Object)"updating old interface with new set/url");
                    ((DatasourceManagerService)this.dmService.getService()).updateBaseUrl(datasourceId, oldId, baseUrl);
                    if (set.equalsIgnoreCase("none")) {
                        ((DatasourceManagerService)this.dmService.getService()).deleteAccessParamOrExtraField(datasourceId, oldId, "set");
                    } else {
                        ((DatasourceManagerService)this.dmService.getService()).updateAccessParam(datasourceId, oldId, "set", set, false);
                    }
                    logger.debug((Object)"deleting new interface");
                    ((DatasourceManagerService)this.dmService.getService()).deleteInterface(datasourceId, interfaceId);
                }
                logger.debug((Object)("updating repository " + officialName + " compliance to : " + desiredCompliance));
            }
            Date utilDate = new Date();
            Timestamp date = new Timestamp(utilDate.getTime());
            String updateQuery = "UPDATE datasources SET activationid = " + null + "," + " dateofvalidation = '" + date + "'" + " WHERE id = '" + datasourceId + "'";
            if (((DatasourceManagerService)this.dmService.getService()).updateSQL(datasourceId, updateQuery, false)) {
                logger.debug((Object)"updated successfully");
            } else {
                logger.error((Object)("error while updating: " + updateQuery));
            }
        }
        catch (Exception e) {
            logger.error((Object)("error connecting to dms to set a repo interface as openaire compliant " + officialName), (Throwable)e);
            ret = false;
            throw e;
        }
        return ret;
    }

    public String getMsgSubject() {
        this.msgSubject = this.isUpdateExisting() ? "Request to update an OpenAIRE " + this.repoType + " " : "Request to Join OpenAIRE ";
        return this.msgSubject;
    }

    public boolean isUpdateExisting() {
        return this.updateExisting;
    }

    public void setUpdateExisting(boolean updateExisting) {
        this.updateExisting = updateExisting;
    }

    public Emailer getEmailer() {
        return this.emailer;
    }

    public void setEmailer(Emailer emailer) {
        this.emailer = emailer;
    }

    public String getValBaseUrl() {
        return this.valBaseUrl;
    }

    public void setValBaseUrl(String valBaseUrl) {
        this.valBaseUrl = valBaseUrl;
    }

    public String getActivationId() {
        return this.activationId;
    }

    public void setActivationId(String activationId) {
        this.activationId = activationId;
    }

    public String getUserMail() {
        return this.userMail;
    }

    public void setUserMail(String userMail) {
        this.userMail = userMail;
    }

    public String getOfficialName() {
        return this.officialName;
    }

    public void setOfficialName(String officialName) {
        this.officialName = officialName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }

    public String getValidationSet() {
        return this.validationSet;
    }

    public void setValidationSet(String validationSet) {
        this.validationSet = validationSet;
    }

    public List<String> getAdminEmails() {
        return this.adminEmails;
    }

    public void setAdminEmails(List<String> adminEmails) {
        this.adminEmails = adminEmails;
    }

    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object object, Map<String, Object> recordContext, Throwable t) {
    }

    public synchronized void currentResults(List<CompletedTask> tasks, int jobId, Object object, Map<String, Object> recordContext) {
    }

    public String getDesiredCompLevel() {
        return this.desiredCompLevel;
    }

    public void setDesiredCompLevel(String desiredCompLevel) {
        this.desiredCompLevel = desiredCompLevel;
    }

    public String getRepoType() {
        return this.repoType;
    }

    public void setRepoType(String repoType) {
        this.repoType = repoType;
    }

    public String getInterfaceIdOld() {
        return this.interfaceIdOld;
    }

    public void setInterfaceIdOld(String interfaceIdOld) {
        this.interfaceIdOld = interfaceIdOld;
    }

    public int getTotalJobs() {
        return this.totalJobs;
    }

    public void setTotalJobs(int totalJobs) {
        this.totalJobs = totalJobs;
    }

    public ServiceLocator<DatasourceManagerService> getDmService() {
        return this.dmService;
    }

    public void setDmService(ServiceLocator<DatasourceManagerService> dmService) {
        this.dmService = dmService;
    }

    public JobsDAO getJobsDao() {
        return this.jobsDao;
    }

    public void setJobsDao(JobsDAO jobsDao) {
        this.jobsDao = jobsDao;
    }
}

