/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.rules.xml;

import eu.dnetlib.validator.engine.data.DataException;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.rules.RegularExpressionRule;
import eu.dnetlib.validator.service.impls.rules.xml.XMLRule;
import eu.dnetlib.validator.service.impls.valobjs.XMLTextValidationObject;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLRegularExpressionRule
extends RegularExpressionRule
implements XMLRule {
    private static final long serialVersionUID = -7791692519583028162L;

    public XMLRegularExpressionRule(Properties pros, int id) {
        super(pros, id);
    }

    public boolean apply(ValidationObject obj) {
        NodeList nodes;
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes(this.pros.getProperty("xpath"));
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        int success = 0;
        int all = nodes.getLength();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            this.log.debug((Object)("XML RegExp Rule. Field Value: " + node.getNodeValue()));
            if (!node.getNodeValue().matches(this.pros.getProperty("regexp"))) continue;
            ++success;
        }
        String successConditions = this.pros.getProperty("success");
        return XMLRule.Utils.success((String)successConditions, (int)success, (int)all);
    }
}

