/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.rules.xml;

import eu.dnetlib.validator.engine.data.DataException;
import eu.dnetlib.validator.engine.data.RuleException;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.rules.VocabularyRule;
import eu.dnetlib.validator.service.impls.rules.xml.XMLRule;
import eu.dnetlib.validator.service.impls.valobjs.XMLTextValidationObject;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLVocabularyRule
extends VocabularyRule
implements XMLRule {
    private static final long serialVersionUID = 5138104621562420041L;

    public XMLVocabularyRule(Properties pros, int id) {
        super(pros, id);
    }

    public boolean apply(ValidationObject obj) throws RuleException {
        NodeList nodes;
        String[] aterms = this.pros.getProperty("terms").split(",");
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes(this.pros.getProperty("xpath"));
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        int success = 0;
        int all = nodes.getLength();
        block2: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            this.log.debug((Object)("XML Vocabulary Rule. Node: " + node.getNodeValue()));
            for (String term : aterms) {
                if (!term.trim().equals(node.getNodeValue().trim())) continue;
                this.log.debug((Object)("XML Vocabulary Rule. Node: " + node.getNodeValue().trim() + " matches with " + term));
                ++success;
                continue block2;
            }
        }
        String successConditions = this.pros.getProperty("success");
        Boolean result = XMLRule.Utils.success((String)successConditions, (int)success, (int)all);
        if (!this.pros.containsKey("terms_type")) {
            this.pros.setProperty("terms_type", "blacklist");
        }
        if (this.pros.getProperty("terms_type").toLowerCase().equals("blacklist")) {
            return result == false;
        }
        if (this.pros.getProperty("terms_type").toLowerCase().equals("whitelist")) {
            return result;
        }
        return result;
    }
}

