/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls;

import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.validator.commons.dao.jobs.JobsDAO;
import eu.dnetlib.validator.commons.dao.rules.RulesetsDAO;
import eu.dnetlib.validator.engine.ValidatorException;
import eu.dnetlib.validator.service.impl.ValidatorManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRED)
public class ValidatorRestore {
    private JobsDAO jobsDao;
    private RulesetsDAO rulesetsDao;
    private ValidatorManager valManager;
    private boolean autoRestoreOnStartup;
    private static Logger logger = Logger.getLogger(ValidatorRestore.class);

    public List<StoredJob> deleteUncompleted() {
        ArrayList<StoredJob> unCompletedJobs = new ArrayList();
        try {
            logger.info((Object)"Checking for uncompleted jobs");
            unCompletedJobs = this.jobsDao.getUncompletedJobs();
            logger.info((Object)("Uncompleted jobs found: " + unCompletedJobs.size()));
            if (unCompletedJobs.size() > 0) {
                logger.info((Object)"deleting uncompleted jobs..");
                this.jobsDao.deleteUncompletedJobs();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error deleting uncompleted jobs", (Throwable)e);
        }
        return unCompletedJobs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restartJobs(List<StoredJob> jobs) {
        try {
            for (StoredJob job : jobs) {
                try {
                    if (job.getUserEmail().equalsIgnoreCase("workflow service")) continue;
                    logger.debug((Object)("Restarting job: " + job.getId()));
                    HashSet<Integer> contentRules = new HashSet<Integer>();
                    HashSet<Integer> usageRules = new HashSet<Integer>();
                    for (RuleSet ruleset : this.rulesetsDao.getRuleSets()) {
                        if (!ruleset.getGuidelinesAcronym().equals(job.getDesiredCompatibilityLevel())) continue;
                        Iterator i$ = job.getRules().iterator();
                        while (i$.hasNext()) {
                            int ruleId = (Integer)i$.next();
                            if (ruleset.getContentRulesIds().contains(ruleId)) {
                                contentRules.add(ruleId);
                                continue;
                            }
                            if (!ruleset.getUsageRulesIds().contains(ruleId)) continue;
                            usageRules.add(ruleId);
                        }
                    }
                    if (!contentRules.isEmpty()) {
                        job.setSelectedContentRules(contentRules);
                    }
                    if (!usageRules.isEmpty()) {
                        job.setSelectedUsageRules(usageRules);
                    }
                    this.valManager.submitJob((JobForValidation)job);
                }
                catch (Exception e) {
                    logger.error((Object)"error Re-Submitting validation job", (Throwable)e);
                    throw new ValidatorException((Throwable)e);
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"error while restarting uncompleted jobs", (Throwable)e);
        }
    }

    public ValidatorManager getValManager() {
        return this.valManager;
    }

    public void setValManager(ValidatorManager valManager) {
        this.valManager = valManager;
    }

    public JobsDAO getJobsDao() {
        return this.jobsDao;
    }

    public void setJobsDao(JobsDAO jobsDao) {
        this.jobsDao = jobsDao;
    }

    public RulesetsDAO getRulesetsDao() {
        return this.rulesetsDao;
    }

    public void setRulesetsDao(RulesetsDAO rulesetsDao) {
        this.rulesetsDao = rulesetsDao;
    }

    public boolean isAutoRestoreOnStartup() {
        return this.autoRestoreOnStartup;
    }

    public void setAutoRestoreOnStartup(boolean autoRestoreOnStartup) {
        this.autoRestoreOnStartup = autoRestoreOnStartup;
    }
}

