/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.executors;

import eu.dnetlib.validator.engine.data.Provider;
import eu.dnetlib.validator.engine.data.ResultSet;
import eu.dnetlib.validator.engine.data.Rule;
import eu.dnetlib.validator.engine.execution.JobListener;
import eu.dnetlib.validator.engine.execution.Task;
import eu.dnetlib.validator.engine.execution.TaskList;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.executors.JobWorker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.core.task.SyncTaskExecutor;

public class JobWorker
implements Runnable {
    private transient Logger log = Logger.getLogger(JobWorker.class);
    private final SyncTaskExecutor taskExecutor;
    public final long generalTimeout;
    public final String set;
    public final int jobId;
    public final Set<Rule> rules;
    public final Provider provider;
    public final JobListener validatorListener;
    public final JobListener[] listeners;
    protected Map<String, Object> jobContext;
    private Map<String, Object> recordContext;
    private int deletedRecords = 0;

    public JobWorker(int jobId, Set<Rule> rules, String set, Provider provider, JobListener validatorListener, SyncTaskExecutor taskExecutor, long generalTimeout, JobListener ... listeners) {
        this.log.debug((Object)("Creating a new job Worker with generalTimeout " + generalTimeout));
        this.taskExecutor = taskExecutor;
        this.generalTimeout = generalTimeout;
        this.set = set;
        this.jobId = jobId;
        this.rules = rules;
        this.provider = provider;
        this.jobContext = new HashMap();
        this.listeners = listeners;
        this.validatorListener = validatorListener;
    }

    public void submit() throws JobWorkerException {
        long elapsed = 0L;
        int count = 0;
        int record_limit = -1;
        this.log.debug((Object)"Submitting job");
        if (this.provider.getConfiguration().getProperty("records") != null && !this.provider.getConfiguration().getProperty("records").trim().equals("-1")) {
            record_limit = Integer.parseInt(this.provider.getConfiguration().getProperty("records").trim());
        }
        if (this.provider.getConfiguration().getProperty("RECORDS") != null && !this.provider.getConfiguration().getProperty("RECORDS").trim().equals("-1")) {
            record_limit = Integer.parseInt(this.provider.getConfiguration().getProperty("RECORDS").trim());
        }
        this.log.debug((Object)("Number of records to validate: " + record_limit + " (-1 for all)"));
        Boolean crisFlag = false;
        if (this.set != null && this.set.contains("_cris_")) {
            crisFlag = true;
        }
        boolean success = false;
        ArrayList<Task> tasks = new ArrayList<Task>();
        ResultSet ivobjs = null;
        try {
            if (!crisFlag.booleanValue()) {
                this.log.debug((Object)"request to get validation objects without set..");
                ivobjs = this.provider.getValidationObjects();
            } else {
                this.log.debug((Object)("request to get validation objects with set: " + this.set));
                ivobjs = this.provider.getValidationObjects(this.set);
            }
        }
        catch (Provider.ProviderException e1) {
            this.log.error((Object)"Error while getting validation objects from provider", (Throwable)e1);
            for (JobListener listener : this.listeners) {
                listener.failed(this.jobId, this.jobContext, (Throwable)e1);
            }
        }
        try {
            long recordsTime = 0L;
            while ((count < record_limit || record_limit == -1) && ivobjs.next()) {
                this.recordContext = new HashMap();
                tasks.clear();
                ValidationObject vobj = (ValidationObject)ivobjs.get();
                this.log.debug((Object)("Checking if rules will be applied on object " + vobj.getId()));
                if (vobj.getStatus() != null && vobj.getStatus().equalsIgnoreCase("deleted")) {
                    this.log.debug((Object)"Object is deleted and will be ignored");
                    ++this.deletedRecords;
                    continue;
                }
                if (crisFlag.booleanValue() && (vobj.getId().contains("cfEAddr") || vobj.getId().contains("cfEquip"))) {
                    this.log.debug((Object)"ignoring cfEaddr and cfEquip records from persons and datasets");
                    continue;
                }
                this.log.debug((Object)("Applying rules on object " + vobj.getId()));
                ++count;
                for (Rule rule : this.rules) {
                    if (rule == null) continue;
                    rule.setValObjId(vobj.getId());
                    rule.setProvider(this.provider);
                    Task task = new Task(vobj, rule);
                    tasks.add(task);
                }
                TaskList ltasks = new TaskList(tasks);
                try {
                    long time1 = Calendar.getInstance().getTimeInMillis();
                    this.taskExecutor.execute((Runnable)ltasks);
                    long time2 = Calendar.getInstance().getTimeInMillis();
                    this.log.debug((Object)("Task execution took " + (time2 - time1) + " milli seconds"));
                    this.log.debug((Object)("Elapsed time till now is " + (elapsed += time2 - time1) / 1000L + " seconds"));
                    recordsTime += time2 - time1;
                    long time3 = Calendar.getInstance().getTimeInMillis();
                    for (JobListener listener : this.listeners) {
                        listener.currentResults(ltasks.getCtasks(), this.jobId, vobj.getContentAsObject(), this.recordContext);
                    }
                    long time4 = Calendar.getInstance().getTimeInMillis();
                    this.log.debug((Object)("Informing listeners took " + (time4 - time3) + " milli seconds"));
                    success = true;
                }
                catch (Exception e) {
                    this.log.error((Object)"an error occured while executing tasks: ", (Throwable)e);
                    for (JobListener listener : this.listeners) {
                        listener.currentResults(ltasks.getCtasks(), this.jobId, vobj.getContentAsObject(), this.recordContext, (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"data error", (Throwable)e);
            for (JobListener listener : this.listeners) {
                listener.failed(this.jobId, this.jobContext, (Throwable)e);
            }
        }
        if (success) {
            this.jobContext.put("deletedRecords", this.deletedRecords);
            for (JobListener listener : this.listeners) {
                listener.finished(this.jobId, this.jobContext);
            }
        } else {
            this.log.error((Object)"an error occured");
            for (JobListener listener : this.listeners) {
                if (ivobjs.getError() == null) {
                    listener.failed(this.jobId, this.jobContext, (Throwable)new JobWorkerException(this, "All tasks failed"));
                    continue;
                }
                listener.failed(this.jobId, this.jobContext, (Throwable)new JobWorkerException(this, ivobjs.getError()));
                this.log.error((Object)"an error occured.", (Throwable)new JobWorkerException(this, ivobjs.getError()));
            }
        }
    }

    @Override
    public void run() {
        try {
            this.submit();
        }
        catch (JobWorkerException e) {
            this.log.error((Object)"", (Throwable)e);
            for (JobListener listener : this.listeners) {
                listener.failed(this.jobId, this.jobContext, (Throwable)e);
            }
            this.validatorListener.failed(this.jobId, this.jobContext, (Throwable)e);
            return;
        }
        this.validatorListener.finished(this.jobId, this.jobContext);
    }
}

