/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.listeners;

import eu.dnetlib.api.enabling.ResultSetService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class RSTask
implements Runnable {
    private final ResultSetService resultSetService;
    private final String outputResultSetID;
    private final BlockingQueue<String> queue;
    private final AtomicInteger activeThreads;
    private final Object allThreadsFinished;
    private boolean success;
    private List<String> errors;
    private Exception exception = null;

    public RSTask(ResultSetService resultSetService, String outputResultSetID, BlockingQueue<String> queue, AtomicInteger activeThreads, Object allThreadsFinished) {
        this.resultSetService = resultSetService;
        this.outputResultSetID = outputResultSetID;
        this.queue = queue;
        this.activeThreads = activeThreads;
        this.allThreadsFinished = allThreadsFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long time1;
        Logger log;
        block6: {
            log = Logger.getLogger(RSTask.class);
            time1 = Calendar.getInstance().getTimeInMillis();
            try {
                String record;
                ArrayList<String> outputRSBuffer = new ArrayList<String>();
                for (int i = 0; i < 50 && !(record = (String)this.queue.take()).equalsIgnoreCase("finished"); ++i) {
                    outputRSBuffer.add(record);
                }
                this.resultSetService.populateRS(this.outputResultSetID, outputRSBuffer);
                if (this.activeThreads.decrementAndGet() != 0) break block6;
                Object object = this.allThreadsFinished;
                synchronized (object) {
                    this.allThreadsFinished.notify();
                }
            }
            catch (Exception e) {
                log.error((Object)"Error populating ResultSetService.", (Throwable)e);
            }
        }
        long time2 = Calendar.getInstance().getTimeInMillis();
        log.debug((Object)("Populating RS took " + (time2 - time1) + " milli seconds"));
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Exception getException() {
        return this.exception;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }
}

