/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.providers;

import eu.dnetlib.validator.engine.data.DataException;
import eu.dnetlib.validator.engine.data.Provider;
import eu.dnetlib.validator.engine.data.ResultSet;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.providers.CrisProvider;
import eu.dnetlib.validator.service.impls.valobjs.XMLTextValidationObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class CrisProvider
extends Provider {
    private static final long serialVersionUID = -8496954108693674745L;
    private String baseUrl;
    private String metadataPrefix;
    private String set;
    private String records;
    private String from;
    private String until;
    private int timeout;
    private int delay;
    private int retryDelay;
    private int retryEfforts;
    private Cache cache = null;
    private Set<String> entities;
    private Map<String, OAIPMHResultSet> entityResultSetMap = new HashMap();

    public CrisProvider() {
        super(Integer.valueOf(4));
    }

    public synchronized ResultSet<ValidationObject> getValidationObjects(String entity) throws Provider.ProviderException {
        if (!this.entityResultSetMap.containsKey(entity)) {
            OAIPMHRecordResultSet resultSet = new OAIPMHRecordResultSet(this, null);
            resultSet.setProvider(this);
            resultSet.setValidationSet(entity);
            this.entityResultSetMap.put(entity, resultSet);
        }
        return (ResultSet)this.entityResultSetMap.get(entity);
    }

    public void restartResultSets() {
        HashMap newEntityResultSetMap = new HashMap();
        for (Map.Entry ent : this.entityResultSetMap.entrySet()) {
            OAIPMHReferentialRecordResultSet resultSet = new OAIPMHReferentialRecordResultSet(this);
            resultSet.setProvider(this);
            resultSet.setValidationSet((String)ent.getKey());
            newEntityResultSetMap.put(ent.getKey(), resultSet);
        }
        this.entityResultSetMap = null;
        this.entityResultSetMap = newEntityResultSetMap;
    }

    public ResultSet<String> getValidationObjectIds() throws Provider.ProviderException {
        return new OAIPMHRecordIdentifierResultSet(this);
    }

    public synchronized ValidationObject getValidationObject(String valObjId) throws Provider.ProviderException {
        if (this.cache != null) {
            Element element = this.cache.get((Serializable)((Object)valObjId));
            if (element != null) {
                this.log.debug((Object)"fetching from cache..");
                return (ValidationObject)element.getObjectValue();
            }
            this.log.debug((Object)"fetching from server..");
            ValidationObject ret = this.fetchValidationObject(valObjId);
            return ret;
        }
        return this.fetchValidationObject(valObjId);
    }

    public ResultSet<ValidationObject> getValidationObjects() throws Provider.ProviderException {
        return null;
    }

    public synchronized ValidationObject fetchValidationObject(String valObjId) throws Provider.ProviderException {
        this.log.debug((Object)("fetching object with id: " + valObjId));
        try {
            OAIPMHResultSet oai = new OAIPMHResultSet(this);
            return new XMLTextValidationObject(oai.getRecord(valObjId));
        }
        catch (DataException e) {
            this.log.error((Object)("error fetching object with id: " + valObjId), (Throwable)e);
            throw new Provider.ProviderException((Provider)this);
        }
    }

    public static void printXmlDocument(Document document) {
        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
        String string = lsSerializer.writeToString(document);
        System.out.println(string);
    }

    public Set<String> getEntities() {
        return this.entities;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setEntities(Set<String> entities) {
        this.entities = entities;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public void setMetadataPrefix(String metadataPrefix) {
        this.metadataPrefix = metadataPrefix;
    }

    public String getRecords() {
        return this.records;
    }

    public void setRecords(String records) {
        this.records = records;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getUntil() {
        return this.until;
    }

    public void setUntil(String until) {
        this.until = until;
    }

    public String getSet() {
        return this.set;
    }

    public void setSet(String set) {
        this.set = set;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public Integer getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(Integer retryDelay) {
        this.retryDelay = retryDelay;
    }

    public Integer getRetryEfforts() {
        return this.retryEfforts;
    }

    public void setRetryEfforts(Integer retryEfforts) {
        this.retryEfforts = retryEfforts;
    }

    static /* synthetic */ Cache access$100(CrisProvider x0) {
        return x0.cache;
    }
}

