/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator.service.impls.rules.xml;

import eu.dnetlib.validator.engine.data.DataException;
import eu.dnetlib.validator.engine.data.RuleException;
import eu.dnetlib.validator.engine.execution.ValidationObject;
import eu.dnetlib.validator.service.impls.rules.CardinalityRule;
import eu.dnetlib.validator.service.impls.rules.xml.XMLRule;
import eu.dnetlib.validator.service.impls.valobjs.XMLTextValidationObject;
import java.util.Properties;
import org.w3c.dom.NodeList;

public class XMLCardinalityRule
extends CardinalityRule
implements XMLRule {
    private static final long serialVersionUID = -3293960407395273309L;

    public XMLCardinalityRule(Properties pros, int id) {
        super(pros, id);
    }

    public boolean apply(ValidationObject obj) throws RuleException {
        NodeList nodes;
        XMLTextValidationObject tobj = (XMLTextValidationObject)obj;
        try {
            nodes = tobj.getNodes(this.pros.getProperty("xpath"));
        }
        catch (DataException e) {
            this.log.error((Object)"", (Throwable)e);
            return false;
        }
        int number = nodes.getLength();
        this.log.debug((Object)("XML Cardinality Rule. Count: " + number));
        return number < Integer.parseInt(this.pros.getProperty("lt")) && number > Integer.parseInt(this.pros.getProperty("gt"));
    }
}

